/*
 * Decompiled with CFR 0.152.
 */
package babase.ranker;

import babase.db.Babase;
import babase.db.Individual;
import babase.db.InteractionSpec;
import babase.db.RankingIdentifier;
import babase.ranker.IndividualHeader;
import babase.ranker.ranking.Ranking;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Calendar;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class Cage {
    private static DocumentBuilderFactory _factory = DocumentBuilderFactory.newInstance();
    public final RankingIdentifier rankingId;
    public final InteractionSpec interactionSpec;
    public final IndividualHeader[] individuals;
    public final Ranking ranks;
    public final int[][] matrix;

    public Cage(RankingIdentifier rankingIdentifier, InteractionSpec interactionSpec, Individual[] individualArray, int[] nArray, int[][] nArray2) {
        int n;
        this.rankingId = rankingIdentifier;
        this.interactionSpec = interactionSpec;
        this.individuals = new IndividualHeader[individualArray.length];
        for (n = 0; n < individualArray.length; ++n) {
            this.individuals[n] = new IndividualHeader(individualArray[n]);
        }
        this.ranks = nArray == null ? new Ranking(individualArray.length) : new Ranking(nArray);
        this.matrix = (int[][])nArray2.clone();
        for (n = 0; n < nArray2.length; ++n) {
            this.matrix[n] = (int[])nArray2[n].clone();
        }
    }

    public Cage(RankingIdentifier rankingIdentifier, InteractionSpec interactionSpec, Individual[] individualArray, int[][] nArray) {
        this(rankingIdentifier, interactionSpec, individualArray, null, nArray);
    }

    private void printRepeat(PrintStream printStream, int n, String string) {
        for (int i = 0; i < n; ++i) {
            printStream.print(string);
        }
    }

    public void print(PrintStream printStream) {
        int n;
        int n2;
        int n3;
        int n4;
        printStream.println(this.rankingId);
        printStream.println(this.interactionSpec);
        printStream.println("Printed on " + Babase.datetimeToString(Calendar.getInstance().getTime()));
        printStream.println();
        int n5 = 0;
        for (n4 = 0; n4 < this.individuals.length; ++n4) {
            n3 = this.individuals[n4].sname.length();
            if (n5 >= n3) continue;
            n5 = n3;
        }
        n3 = n4 = Integer.toString(this.ranks.size() + 1).length();
        for (n2 = 0; n2 < this.matrix.length; ++n2) {
            for (n = 0; n < this.matrix[n2].length; ++n) {
                int n6 = Integer.toString(this.matrix[n2][n]).length();
                if (n3 >= n6) continue;
                n3 = n6;
            }
        }
        ++n3;
        for (n2 = 0; n2 < n5; ++n2) {
            this.printRepeat(printStream, n5 + 1 + n4 + 1, " ");
            for (n = 0; n < this.individuals.length; ++n) {
                String string = this.individuals[this.ranks.get((int)n)].sname;
                if (string.length() > n2) {
                    printStream.format("%1$" + n3 + "s", "" + string.charAt(n2));
                    continue;
                }
                this.printRepeat(printStream, n3, " ");
            }
            printStream.println();
        }
        this.printRepeat(printStream, n5 + 1 + n4 + 1, " ");
        for (n2 = 0; n2 < this.individuals.length; ++n2) {
            printStream.format("%1$" + n3 + "d", n2 + 1);
        }
        printStream.println();
        this.printRepeat(printStream, n5 + 1 + n4 + 1, " ");
        this.printRepeat(printStream, this.individuals.length * n3, "_");
        printStream.println();
        for (n2 = 0; n2 < this.individuals.length; ++n2) {
            String string = this.individuals[this.ranks.get((int)n2)].sname;
            printStream.format("%1$" + n5 + "s %2$" + n4 + "d|", string, n2 + 1);
            for (int i = 0; i < this.individuals.length; ++i) {
                int n7 = this.matrix[this.ranks.get(n2)][this.ranks.get(i)];
                if (n2 == i) {
                    this.printRepeat(printStream, n3 - 1, " ");
                    printStream.print("X");
                    continue;
                }
                if (n7 != 0) {
                    printStream.format("%1$" + n3 + "d", n7);
                    continue;
                }
                this.printRepeat(printStream, n3 - 1, " ");
                printStream.print(".");
            }
            printStream.println();
        }
        printStream.println();
    }

    public void dumpToXML(File file) throws Babase.DumpToXMLException {
        try {
            DocumentBuilder documentBuilder = _factory.newDocumentBuilder();
            Document document = documentBuilder.newDocument();
            Element element = document.createElement("ranking");
            document.appendChild(element);
            element.appendChild(this.rankingId.toXML(document));
            element.appendChild(this.interactionSpec.toXML(document));
            Element element2 = document.createElement("individuals");
            element2.setAttribute("n", String.valueOf(this.individuals.length));
            element.appendChild(element2);
            for (int i = 0; i < this.individuals.length; ++i) {
                element2.appendChild(this.individuals[i].toXML(document));
            }
            Element element3 = document.createElement("ranks");
            element3.setAttribute("n", String.valueOf(this.ranks.size()));
            element.appendChild(element3);
            for (int i = 0; i < this.ranks.size(); ++i) {
                Element element4 = document.createElement("rank");
                element4.setAttribute("i", String.valueOf(this.ranks.get(i)));
                element3.appendChild(element4);
            }
            Element element5 = document.createElement("matrix");
            element5.setAttribute("n", String.valueOf(this.individuals.length));
            element.appendChild(element5);
            for (int i = 0; i < this.individuals.length; ++i) {
                for (int j = 0; j < this.individuals.length; ++j) {
                    if (this.matrix[i][j] == 0) continue;
                    Element element6 = document.createElement("entry");
                    element6.setAttribute("i", String.valueOf(i));
                    element6.setAttribute("j", String.valueOf(j));
                    element6.setAttribute("v", String.valueOf(this.matrix[i][j]));
                    element5.appendChild(element6);
                }
            }
            TransformerFactory.newInstance().newTransformer().transform(new DOMSource(document), new StreamResult(file));
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new Babase.DumpToXMLException("XML parser configuration error", parserConfigurationException);
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            throw new Babase.DumpToXMLException("XML transformer configuration error", transformerConfigurationException);
        }
        catch (TransformerException transformerException) {
            throw new Babase.DumpToXMLException("XML transformer error", transformerException);
        }
        catch (TransformerFactoryConfigurationError transformerFactoryConfigurationError) {
            throw new Babase.DumpToXMLException("XML transformer factory configuration error", transformerFactoryConfigurationError);
        }
    }

    public static Cage loadFromXML(File file) throws Babase.LoadFromXMLException {
        try {
            DocumentBuilder documentBuilder = _factory.newDocumentBuilder();
            Document document = documentBuilder.parse(file);
            Element element = document.getDocumentElement();
            RankingIdentifier rankingIdentifier = null;
            InteractionSpec interactionSpec = null;
            Individual[] individualArray = null;
            int[] nArray = null;
            int[][] nArray2 = null;
            for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
                Element element2;
                int n;
                if (node.getNodeType() != 1) continue;
                Element element3 = (Element)node;
                if (element3.getNodeName().equals("rankingId")) {
                    rankingIdentifier = RankingIdentifier.fromXML(element3);
                    continue;
                }
                if (element3.getNodeName().equals("interactionSpec")) {
                    interactionSpec = InteractionSpec.fromXML(element3);
                    continue;
                }
                if (element3.getNodeName().equals("individuals")) {
                    n = Integer.parseInt(element3.getAttribute("n"));
                    individualArray = new Individual[n];
                    int n2 = 0;
                    for (element2 = (Element)element3.getFirstChild(); element2 != null; element2 = (Element)element2.getNextSibling()) {
                        if (n2 > n) {
                            throw new Babase.LoadFromXMLException("element <individuals> contains too many <individual> subelements");
                        }
                        individualArray[n2] = Individual.fromXML(element2);
                        ++n2;
                    }
                    if (n2 >= n) continue;
                    throw new Babase.LoadFromXMLException("element <individuals> contains too few <individual> subelements");
                }
                if (element3.getNodeName().equals("ranks")) {
                    n = Integer.parseInt(element3.getAttribute("n"));
                    nArray = new int[n];
                    int n3 = 0;
                    for (element2 = (Element)element3.getFirstChild(); element2 != null; element2 = (Element)element2.getNextSibling()) {
                        if (n3 > n) {
                            throw new Babase.LoadFromXMLException("element <ranks> contains too many <rank> subelements");
                        }
                        nArray[n3] = Integer.parseInt(element2.getAttribute("i"));
                        ++n3;
                    }
                    if (n3 >= n) continue;
                    throw new Babase.LoadFromXMLException("element <ranks> contains too few <rank> subelements");
                }
                if (!element3.getNodeName().equals("matrix")) continue;
                n = Integer.parseInt(element3.getAttribute("n"));
                nArray2 = new int[n][n];
                for (int i = 0; i < n; ++i) {
                    for (int j = 0; j < n; ++j) {
                        nArray2[i][j] = 0;
                    }
                }
                for (Element element4 = (Element)element3.getFirstChild(); element4 != null; element4 = (Element)element4.getNextSibling()) {
                    int n4 = Integer.parseInt(element4.getAttribute("i"));
                    int n5 = Integer.parseInt(element4.getAttribute("j"));
                    int n6 = Integer.parseInt(element4.getAttribute("v"));
                    if (n4 < 0 || n4 >= n) {
                        throw new Babase.LoadFromXMLException("index i of element <entry i='" + n4 + "' .../> is out of bounds");
                    }
                    if (n5 < 0 || n5 >= n) {
                        throw new Babase.LoadFromXMLException("index j of element <entry ... j='" + n5 + "' .../> is out of bounds");
                    }
                    if (n6 <= 0) {
                        throw new Babase.LoadFromXMLException("value v of element <entry ... v='" + n6 + "/> element is not positive");
                    }
                    nArray2[n4][n5] = n6;
                }
            }
            return new Cage(rankingIdentifier, interactionSpec, individualArray, nArray, nArray2);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new Babase.LoadFromXMLException("XML parser configuration error", parserConfigurationException);
        }
        catch (SAXException sAXException) {
            throw new Babase.LoadFromXMLException("XML parsing error", sAXException);
        }
        catch (IOException iOException) {
            throw new Babase.LoadFromXMLException("error reading file " + file, iOException);
        }
    }
}

