/*
 * Decompiled with CFR 0.152.
 */
package babase.ranker.ranking;

import babase.ranker.ranking.Ranking;

public abstract class RankingChangeEvent {
    public final Object source;
    public final Ranking ranks;

    public RankingChangeEvent(Object object, Ranking ranking) {
        this.source = object;
        this.ranks = ranking;
    }

    public static class Permute
    extends RankingChangeEvent {
        public final int[] before;
        public final int[] after;

        public Permute(Object object, Ranking ranking, int[] nArray, int[] nArray2) {
            super(object, ranking);
            this.before = nArray;
            this.after = nArray2;
        }

        public String toString() {
            int n;
            String string = "PERMUTE([";
            for (n = 0; n < this.before.length; ++n) {
                if (n > 0) {
                    string = string + ", ";
                }
                string = string + (this.before[n] + 1);
            }
            string = string + "] -> [";
            for (n = 0; n < this.after.length; ++n) {
                if (n > 0) {
                    string = string + ", ";
                }
                string = string + (this.after[n] + 1);
            }
            string = string + ']';
            return string;
        }
    }

    public static class Slide
    extends RankingChangeEvent {
        public final int from;
        public final int to;

        public Slide(Object object, Ranking ranking, int n, int n2) {
            super(object, ranking);
            this.from = n;
            this.to = n2;
        }

        public String toString() {
            return "SLIDE(" + (this.from + 1) + "->" + (this.to + 1) + ")";
        }
    }

    public static class Swap
    extends RankingChangeEvent {
        public final int i;
        public final int j;

        public Swap(Object object, Ranking ranking, int n, int n2) {
            super(object, ranking);
            this.i = n;
            this.j = n2;
        }

        public String toString() {
            return "SWAP(" + (this.i + 1) + ", " + (this.j + 1) + ")";
        }
    }
}

