/*
 * Decompiled with CFR 0.152.
 */
package babase.ranker;

import babase.ranker.ranking.Ranking;
import babase.ranker.ranking.RankingChangeEvent;
import babase.ranker.ranking.RankingChangedListener;
import info.clearthought.layout.TableLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.PrintStream;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class HistoryPanel
extends JPanel
implements RankingChangedListener,
ActionListener {
    private static final long serialVersionUID = 1997859215699352960L;
    private final Ranking _ranks;
    private final DefaultListModel _undoListModel;
    private final DefaultListModel _redoListModel;
    private final JList _undoJList;
    private final JList _redoJList;
    private PrintStream _out;

    public HistoryPanel(Ranking ranking) {
        this._ranks = ranking;
        this._undoListModel = new DefaultListModel();
        this._redoListModel = new DefaultListModel();
        this._undoJList = new JList(this._undoListModel);
        this._redoJList = new JList(this._redoListModel);
        this._out = System.out;
        this._ranks.addChangedListener(this);
        double d = 5.0;
        double[] dArray = new double[]{d, -1.0, d, -1.0, d};
        double[] dArray2 = new double[]{d, -2.0, d, -1.0, d};
        this.setLayout((LayoutManager)new TableLayout(dArray, dArray2));
        JButton jButton = new JButton("Undo");
        jButton.setActionCommand("Undo");
        jButton.addActionListener(this);
        this.add((Component)jButton, "1 1 r c");
        JButton jButton2 = new JButton("Redo");
        jButton2.setActionCommand("Redo");
        jButton2.addActionListener(this);
        this.add((Component)jButton2, "3 1 l c");
        this._undoJList.setSelectionMode(0);
        JScrollPane jScrollPane = new JScrollPane(this._undoJList, 22, 32);
        this.add((Component)jScrollPane, "1 3 f f");
        this._undoJList.setSelectionMode(0);
        JScrollPane jScrollPane2 = new JScrollPane(this._redoJList, 22, 32);
        this.add((Component)jScrollPane2, "3 3 f f");
    }

    public void setOut(PrintStream printStream) {
        this._out = printStream;
    }

    void redo() {
        if (this._redoListModel.size() == 0) {
            this._out.println("Nothing to redo!");
            return;
        }
        RankingChangeEvent rankingChangeEvent = (RankingChangeEvent)this._redoListModel.remove(0);
        if (rankingChangeEvent instanceof RankingChangeEvent.Slide) {
            RankingChangeEvent.Slide slide = (RankingChangeEvent.Slide)rankingChangeEvent;
            this._ranks.slide(slide.from, slide.to, this);
        } else if (rankingChangeEvent instanceof RankingChangeEvent.Swap) {
            RankingChangeEvent.Swap swap = (RankingChangeEvent.Swap)rankingChangeEvent;
            this._ranks.swap(swap.i, swap.j, this);
        } else if (rankingChangeEvent instanceof RankingChangeEvent.Permute) {
            RankingChangeEvent.Permute permute = (RankingChangeEvent.Permute)rankingChangeEvent;
            this._ranks.permute(permute.after, this);
        }
        this._undoListModel.addElement(rankingChangeEvent);
        this._undoJList.ensureIndexIsVisible(this._undoListModel.size() - 1);
    }

    void undo() {
        if (this._undoListModel.size() == 0) {
            this._out.println("Nothing to undo!");
            return;
        }
        RankingChangeEvent rankingChangeEvent = (RankingChangeEvent)this._undoListModel.remove(this._undoListModel.size() - 1);
        if (rankingChangeEvent instanceof RankingChangeEvent.Slide) {
            RankingChangeEvent.Slide slide = (RankingChangeEvent.Slide)rankingChangeEvent;
            this._ranks.slide(slide.to, slide.from, this);
        } else if (rankingChangeEvent instanceof RankingChangeEvent.Swap) {
            RankingChangeEvent.Swap swap = (RankingChangeEvent.Swap)rankingChangeEvent;
            this._ranks.swap(swap.j, swap.i, this);
        } else if (rankingChangeEvent instanceof RankingChangeEvent.Permute) {
            RankingChangeEvent.Permute permute = (RankingChangeEvent.Permute)rankingChangeEvent;
            this._ranks.permute(permute.before, this);
        }
        this._redoListModel.add(0, rankingChangeEvent);
        this._redoJList.ensureIndexIsVisible(0);
    }

    @Override
    public void rankingChanged(RankingChangeEvent rankingChangeEvent) {
        if (rankingChangeEvent.source == this) {
            return;
        }
        this._undoListModel.addElement(rankingChangeEvent);
        this._undoJList.ensureIndexIsVisible(this._undoListModel.size() - 1);
        if (this._redoListModel.size() != 0) {
            this._redoListModel.clear();
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("Undo")) {
            int n = this._undoJList.getSelectedIndex();
            if (n == -1) {
                this.undo();
            } else if (n == this._undoListModel.size() - 1) {
                this._undoJList.clearSelection();
                this.undo();
            } else {
                this._out.print("Undoing " + (this._undoListModel.size() - n - 1) + " operation(s)... ");
                for (int i = this._undoListModel.size() - 1; i > n; --i) {
                    this.undo();
                }
                this._out.println("Done!");
            }
        } else if (actionEvent.getActionCommand().equals("Redo")) {
            int n = this._redoJList.getSelectedIndex();
            if (n == -1) {
                this.redo();
            } else if (n == 0) {
                this._redoJList.clearSelection();
                this.redo();
            } else {
                this._out.print("Redoing " + n + " operation(s)... ");
                for (int i = 0; i < n; ++i) {
                    this.redo();
                }
                this._out.println("Done!");
            }
        }
    }
}

