/*
 * Decompiled with CFR 0.152.
 */
package babase.ranker;

import babase.ranker.Header;
import babase.ranker.Utils;
import babase.ranker.ranking.Ranking;
import babase.ranker.ranking.RankingChangeEvent;
import babase.ranker.ranking.RankingChangedListener;
import java.awt.Color;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.PrintStream;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.Border;

public class SlidableHeader
extends JPanel
implements RankingChangedListener,
MouseListener {
    private static final long serialVersionUID = 3186378565571657862L;
    protected Ranking _ranks;
    protected final Header[] _headers;
    protected SlidableHeaderCell[] _headerButtons;
    protected int _pressedPosition = -1;
    protected int _lastExitedPosition = -1;
    protected int _lastEnteredPosition = -1;
    protected PrintStream _out = System.out;

    public SlidableHeader(Ranking ranking, Header[] headerArray) {
        this._ranks = ranking;
        this._headers = headerArray;
        this._headerButtons = new SlidableHeaderCell[this._ranks.size()];
        this._ranks.addChangedListener(this);
        this.setLayout(new GridLayout(1, this._ranks.size()));
        for (int i = 0; i < this._ranks.size(); ++i) {
            this._headerButtons[i] = new SlidableHeaderCell(i);
            this._headerButtons[i].addMouseListener(this);
            this.add(this._headerButtons[i]);
        }
        this.refresh();
    }

    public int getDisplayWidth() {
        return this._ranks.size();
    }

    public int getDisplayHeight() {
        return Utils.findDisplayLength(this._headers);
    }

    public void setOut(PrintStream printStream) {
        this._out.flush();
        this._out = printStream;
    }

    protected void refreshHeaderButton(int n) {
        this._headerButtons[n].setHeader(this._headers[this._ranks.get(n)]);
    }

    public void refresh() {
        for (int i = 0; i < this._ranks.size(); ++i) {
            this.refreshHeaderButton(i);
        }
    }

    @Override
    public void rankingChanged(RankingChangeEvent rankingChangeEvent) {
        block3: {
            block4: {
                block2: {
                    if (!(rankingChangeEvent instanceof RankingChangeEvent.Slide)) break block2;
                    RankingChangeEvent.Slide slide = (RankingChangeEvent.Slide)rankingChangeEvent;
                    int n = slide.from > slide.to ? slide.to : slide.from;
                    int n2 = slide.from > slide.to ? slide.from : slide.to;
                    for (int i = n; i <= n2; ++i) {
                        this.refreshHeaderButton(i);
                    }
                    break block3;
                }
                if (!(rankingChangeEvent instanceof RankingChangeEvent.Swap)) break block4;
                RankingChangeEvent.Swap swap = (RankingChangeEvent.Swap)rankingChangeEvent;
                this.refreshHeaderButton(swap.i);
                this.refreshHeaderButton(swap.j);
                break block3;
            }
            if (!(rankingChangeEvent instanceof RankingChangeEvent.Permute)) break block3;
            for (int i = 0; i < this._ranks.size(); ++i) {
                this.refreshHeaderButton(i);
            }
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        if (this._pressedPosition == -1) {
            return;
        }
        this._lastEnteredPosition = ((SlidableHeaderCell)mouseEvent.getSource()).position;
        this._headerButtons[this._lastExitedPosition].setSelected(false);
        this._headerButtons[this._lastEnteredPosition].setSelected(true);
        this._ranks.slide(this._lastExitedPosition, this._lastEnteredPosition, this);
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        if (this._pressedPosition == -1) {
            return;
        }
        this._lastExitedPosition = ((SlidableHeaderCell)mouseEvent.getSource()).position;
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        assert (this._pressedPosition == -1);
        this._pressedPosition = ((SlidableHeaderCell)mouseEvent.getSource()).position;
        this._headerButtons[this._pressedPosition].setSelected(true);
        this._out.println("Sliding " + this._headers[this._ranks.get(this._pressedPosition)].getText() + " from rank " + (this._pressedPosition + 1) + "...");
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        assert (this._pressedPosition == ((SlidableHeaderCell)mouseEvent.getSource()).position);
        this._headerButtons[this._pressedPosition].setSelected(false);
        if (this._lastEnteredPosition == -1) {
            this._out.println("Sliding cancelled");
        } else {
            this._out.println("Slided " + this._headers[this._ranks.get(this._lastEnteredPosition)].getText() + " from rank " + (this._pressedPosition + 1) + " to " + (this._lastEnteredPosition + 1));
        }
        if (this._lastExitedPosition != -1) {
            this._headerButtons[this._lastExitedPosition].setSelected(false);
        }
        if (this._lastEnteredPosition != -1) {
            this._headerButtons[this._lastEnteredPosition].setSelected(false);
        }
        this._pressedPosition = -1;
        this._lastExitedPosition = -1;
        this._lastEnteredPosition = -1;
    }

    protected static class SlidableHeaderCell
    extends JLabel {
        private static final long serialVersionUID = 2833160457486391980L;
        protected static final Border loweredEtchedBorder = BorderFactory.createEtchedBorder(1);
        protected final int position;
        protected final Color defaultBackground;

        public SlidableHeaderCell(int n) {
            this.position = n;
            this.setHorizontalAlignment(0);
            this.setFont((Font)UIManager.get(this.getClass().getName() + ".font"));
            this.setBorder(loweredEtchedBorder);
            this.setOpaque(true);
            this.defaultBackground = this.getBackground();
        }

        @Override
        public void updateUI() {
            super.updateUI();
            this.setFont((Font)UIManager.get(this.getClass().getName() + ".font"));
        }

        public void setSelected(boolean bl) {
            if (bl) {
                this.setBackground(Color.ORANGE);
            } else {
                this.setBackground(this.defaultBackground);
            }
        }

        public void setHeader(Header header) {
            String string = header.getText();
            String string2 = "<html><center>";
            for (int i = 0; i < string.length(); ++i) {
                if (i > 0) {
                    string2 = string2 + "<br>";
                }
                string2 = string2 + string.charAt(i);
            }
            string2 = string2 + "</center></html>";
            this.setText(string2);
            this.setToolTipText(header.getToolTipText());
        }
    }
}

