/*
 * Decompiled with CFR 0.152.
 */
package babase.ranker;

import babase.ranker.ranking.Ranking;
import babase.ranker.ranking.RankingChangeEvent;
import babase.ranker.ranking.RankingChangedListener;
import java.awt.Color;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Insets;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.UIManager;

public class InteractionMatrixDisplay
extends JPanel
implements RankingChangedListener {
    private static final long serialVersionUID = 3799732940123199825L;
    private final Ranking _ranks;
    private final int[][] _matrix;
    private final DisplayEntry[][] _displayEntries;
    private final ButtonGroup _displayGroup;
    private final JToggleButton _displayNoneSelected;

    public InteractionMatrixDisplay(Ranking ranking, int[][] nArray) {
        this._ranks = ranking;
        this._matrix = nArray;
        this._displayEntries = new DisplayEntry[this._ranks.size()][this._ranks.size()];
        this._displayGroup = new ButtonGroup();
        this._displayNoneSelected = new JToggleButton();
        this._ranks.addChangedListener(this);
        this.setLayout(new GridLayout(this._ranks.size(), this._ranks.size()));
        for (int i = 0; i < this._ranks.size(); ++i) {
            for (int j = 0; j < this._ranks.size(); ++j) {
                this._displayEntries[i][j] = new DisplayEntry(i, j);
                this.add(this._displayEntries[i][j]);
                this._displayGroup.add(this._displayEntries[i][j]);
            }
        }
        this._displayGroup.add(this._displayNoneSelected);
        this.refresh();
    }

    public Ranking getRanks() {
        return this._ranks;
    }

    public int getDisplayCellWidth() {
        int n = 0;
        for (int i = 0; i < this._matrix.length; ++i) {
            for (int j = 0; j < this._matrix[i].length; ++j) {
                if (Integer.toString(this._matrix[i][j]).length() <= n) continue;
                n = Integer.toString(this._matrix[i][j]).length();
            }
        }
        return n;
    }

    public int getDisplayCellHeight() {
        return 1;
    }

    public void selectDisplayEntry(int n, int n2) {
        this._displayEntries[n][n2].setSelected(true);
    }

    private void refreshDisplayEntry(int n, int n2) {
        if (this._displayEntries[n][n2].isSelected()) {
            this._displayNoneSelected.setSelected(true);
        }
        this._displayEntries[n][n2].setValue(this._matrix[this._ranks.get(n)][this._ranks.get(n2)]);
    }

    public void refresh() {
        for (int i = 0; i < this._ranks.size(); ++i) {
            for (int j = 0; j < this._ranks.size(); ++j) {
                this.refreshDisplayEntry(i, j);
            }
        }
    }

    @Override
    public void rankingChanged(RankingChangeEvent rankingChangeEvent) {
        if (rankingChangeEvent instanceof RankingChangeEvent.Slide) {
            int n;
            int n2;
            RankingChangeEvent.Slide slide = (RankingChangeEvent.Slide)rankingChangeEvent;
            int n3 = slide.from > slide.to ? slide.to : slide.from;
            int n4 = slide.from > slide.to ? slide.from : slide.to;
            for (n2 = 0; n2 < this._ranks.size(); ++n2) {
                for (n = n3; n <= n4; ++n) {
                    this.refreshDisplayEntry(n2, n);
                }
            }
            for (n2 = n3; n2 <= n4; ++n2) {
                for (n = 0; n < n3; ++n) {
                    this.refreshDisplayEntry(n2, n);
                }
                for (n = n4 + 1; n < this._ranks.size(); ++n) {
                    this.refreshDisplayEntry(n2, n);
                }
            }
        } else if (rankingChangeEvent instanceof RankingChangeEvent.Swap) {
            int n;
            int n5 = ((RankingChangeEvent.Swap)rankingChangeEvent).i;
            int n6 = ((RankingChangeEvent.Swap)rankingChangeEvent).j;
            for (n = 0; n < this._ranks.size(); ++n) {
                this.refreshDisplayEntry(n5, n);
                this.refreshDisplayEntry(n6, n);
            }
            for (n = 0; n < this._ranks.size(); ++n) {
                if (n == n5 || n == n6) continue;
                this.refreshDisplayEntry(n, n5);
                this.refreshDisplayEntry(n, n6);
            }
        } else if (rankingChangeEvent instanceof RankingChangeEvent.Permute) {
            this.refresh();
        }
    }

    public static class DisplayEntry
    extends JToggleButton {
        private static final long serialVersionUID = 997196787831598016L;
        private static final Insets insets = new Insets(0, 0, 0, 0);

        public DisplayEntry(int n, int n2) {
            this.setFont((Font)UIManager.get(this.getClass().getName() + ".font"));
            this.setMargin(insets);
            if (n == n2) {
                this.setBackground(Color.LIGHT_GRAY);
            } else {
                this.setBackground(Color.WHITE);
            }
        }

        @Override
        public void updateUI() {
            super.updateUI();
            this.setFont((Font)UIManager.get(this.getClass().getName() + ".font"));
        }

        public void setValue(int n) {
            this.setText(n == 0 ? "" : Integer.toString(n));
            if (n == 0) {
                this.setToolTipText(null);
            } else {
                this.setToolTipText(Integer.toString(n));
            }
        }
    }
}

