/*
 * Decompiled with CFR 0.152.
 */
package babase.ranker.ranking;

import babase.ranker.ranking.RankingChangeEvent;
import babase.ranker.ranking.RankingChangedListener;
import java.util.ArrayList;

public class Ranking {
    protected int[] _ranks;
    protected ArrayList<RankingChangedListener> _changedListeners;

    public Ranking(int n) {
        this._ranks = new int[n];
        for (int i = 0; i < n; ++i) {
            this._ranks[i] = i;
        }
        this._changedListeners = new ArrayList();
    }

    public Ranking(int[] nArray) {
        this(nArray.length);
        int n;
        boolean[] blArray = new boolean[nArray.length];
        for (n = 0; n < blArray.length; ++n) {
            blArray[n] = false;
        }
        for (n = 0; n < nArray.length; ++n) {
            this._ranks[n] = nArray[n];
            assert (!blArray[this._ranks[n]]);
            blArray[this._ranks[n]] = true;
        }
    }

    public void addChangedListener(RankingChangedListener rankingChangedListener) {
        this._changedListeners.add(rankingChangedListener);
    }

    public void removeChangedListener(RankingChangedListener rankingChangedListener) {
        this._changedListeners.remove(rankingChangedListener);
    }

    public int size() {
        return this._ranks.length;
    }

    public int get(int n) {
        return this._ranks[n];
    }

    public int[] get() {
        return (int[])this._ranks.clone();
    }

    public void swap(int n, int n2, Object object) {
        if (n == n2) {
            return;
        }
        int n3 = this._ranks[n];
        this._ranks[n] = this._ranks[n2];
        this._ranks[n2] = n3;
        for (RankingChangedListener rankingChangedListener : this._changedListeners.toArray(new RankingChangedListener[this._changedListeners.size()])) {
            rankingChangedListener.rankingChanged(new RankingChangeEvent.Swap(object, this, n, n2));
        }
    }

    public void slide(int n, int n2, Object object) {
        int n3;
        if (n == n2) {
            return;
        }
        int n4 = this._ranks[n];
        if (n > n2) {
            for (n3 = n; n3 > n2; --n3) {
                this._ranks[n3] = this._ranks[n3 - 1];
            }
        } else {
            for (n3 = n; n3 < n2; ++n3) {
                this._ranks[n3] = this._ranks[n3 + 1];
            }
        }
        this._ranks[n2] = n4;
        for (RankingChangedListener rankingChangedListener : this._changedListeners.toArray(new RankingChangedListener[this._changedListeners.size()])) {
            rankingChangedListener.rankingChanged(new RankingChangeEvent.Slide(object, this, n, n2));
        }
    }

    public void permute(int[] nArray, Object object) {
        int[] nArray2 = (int[])this._ranks.clone();
        for (int i = 0; i < this._ranks.length; ++i) {
            this._ranks[i] = nArray[i];
        }
        for (RankingChangedListener rankingChangedListener : this._changedListeners.toArray(new RankingChangedListener[this._changedListeners.size()])) {
            rankingChangedListener.rankingChanged(new RankingChangeEvent.Permute(object, this, nArray2, nArray));
        }
    }
}

