/*
 * Decompiled with CFR 0.152.
 */
package babase.db;

import babase.db.Babase;
import babase.db.Group;
import babase.db.RankType;
import java.util.Date;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class RankingIdentifier {
    public final Group group;
    public final RankType rankType;
    public final Date startDate;
    public final Date endDate;

    public RankingIdentifier(Group group, RankType rankType, Date date, Date date2) {
        this.group = group;
        this.rankType = rankType;
        this.startDate = (Date)date.clone();
        this.endDate = (Date)date2.clone();
    }

    public RankingIdentifier(Group group, RankType rankType, Date date) {
        this.group = group;
        this.rankType = rankType;
        this.startDate = (Date)date.clone();
        this.endDate = Babase.endOfMonth(date);
    }

    public String toString() {
        return this.group.name + " " + this.rankType.type + " " + Babase.dateToString(this.startDate) + "~" + Babase.dateToString(this.endDate);
    }

    public Element toXML(Document document) {
        Element element = document.createElement("rankingId");
        element.setAttribute("startDate", Babase.dateToXMLString(this.startDate));
        element.setAttribute("endDate", Babase.dateToXMLString(this.endDate));
        element.appendChild(this.rankType.toXML(document));
        element.appendChild(this.group.toXML(document));
        return element;
    }

    public static RankingIdentifier fromXML(Element element) throws Babase.LoadFromXMLException {
        assert (element.getNodeName().equals("rankingId"));
        Date date = Babase.xmlStringToDate(element.getAttribute("startDate"));
        Date date2 = Babase.xmlStringToDate(element.getAttribute("endDate"));
        RankType rankType = null;
        Group group = null;
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 1) continue;
            Element element2 = (Element)node;
            if (element2.getNodeName().equals("rankType")) {
                rankType = RankType.fromXML(element2);
                continue;
            }
            if (element2.getNodeName().equals("group")) {
                group = Group.fromXML(element2);
                continue;
            }
            assert (false);
        }
        return new RankingIdentifier(group, rankType, date, date2);
    }
}

