/*
 * Decompiled with CFR 0.152.
 */
package babase.ranker;

import babase.db.Babase;
import babase.db.RankingInfo;
import babase.ranker.Cage;
import babase.ranker.HistoryPanel;
import babase.ranker.InteractionMatrixDisplay;
import babase.ranker.LoadUI;
import babase.ranker.LoginUI;
import babase.ranker.Main;
import babase.ranker.MessagePanel;
import babase.ranker.SlidableHeader;
import babase.ranker.StatsPanel;
import babase.ranker.SwappableHeader;
import babase.ranker.Utils;
import babase.ranker.auto.AlphabeticalAutoRanker;
import babase.ranker.auto.DefaultAutoRanker;
import babase.ranker.ranking.RankingChangeEvent;
import babase.ranker.ranking.RankingChangedListener;
import info.clearthought.layout.TableLayout;
import info.clearthought.layout.TableLayoutConstraints;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.sql.SQLException;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.FontUIResource;

public class MainUI
extends JFrame {
    private static final long serialVersionUID = -1020260228492294181L;
    private final MainUI _this = this;
    private final Babase _db;
    private final Cage _cage;
    private boolean _ranksSaved = false;
    private int _fontSizeDelta = 0;
    private final InteractionMatrixDisplay _interactionMatrixDisplay;
    private final SlidableHeader _slidableHeader;
    private final SwappableHeader _swappableHeader;
    private final StatsPanel _statsPanel;
    private final HistoryPanel _historyPanel;
    private final PrintStream _out;
    private final JFileChooser _xmlFileChooser;
    private final JFileChooser _textFileChooser;
    private final WindowListener _windowListener;
    private final ActionListener _actionListener;
    private final LoginUI _loginUI;
    private final LoadUI _loadUI;

    public void ranksSaved() {
        this._ranksSaved = true;
        this._cage.ranks.addChangedListener(new RankingChangedListener(){

            @Override
            public void rankingChanged(RankingChangeEvent rankingChangeEvent) {
                MainUI.this._ranksSaved = false;
                ((MainUI)MainUI.this)._cage.ranks.removeChangedListener(this);
            }
        });
    }

    private boolean confirmClosing() {
        if (!this._ranksSaved) {
            Object[] objectArray = new String[]{"Yes", "No"};
            int n = JOptionPane.showOptionDialog(this, "This ranking has not been saved.\nAre you sure you want to close it?", "Warning", 0, 3, null, objectArray, objectArray[1]);
            return n == 0;
        }
        return true;
    }

    private void saveToDatabase() {
        if (!(Babase.isStartOfMonth(this._cage.rankingId.startDate) && Babase.isEndOfMonth(this._cage.rankingId.endDate) && Babase.isInSameMonth(this._cage.rankingId.startDate, this._cage.rankingId.endDate))) {
            JOptionPane.showMessageDialog(this, "Cannot save to Babase: ranking does not start and end on\nthe first and the last days of the same month!\n(You can still save it in XML or print as text.)");
            return;
        }
        try {
            RankingInfo rankingInfo = this._db.getRankingInfo(this._cage.rankingId);
            boolean bl = true;
            if (rankingInfo != null) {
                int n;
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("Existing ranking found for " + this._cage.rankingId.toString() + ":\n");
                for (n = 0; n < rankingInfo.snames.size(); ++n) {
                    stringBuffer.append(rankingInfo.snames.get(rankingInfo.ranks.get(n)));
                    if (n >= rankingInfo.snames.size() - 1) continue;
                    stringBuffer.append(" ");
                }
                stringBuffer.append("\nYour ranking:\n");
                for (n = 0; n < this._cage.individuals.length; ++n) {
                    stringBuffer.append(this._cage.individuals[this._cage.ranks.get((int)n)].sname);
                    if (n >= this._cage.individuals.length - 1) continue;
                    stringBuffer.append(" ");
                }
                stringBuffer.append("\nDo you want to overwrite the existing ranking?");
                Object[] objectArray = new String[]{"Yes", "No"};
                int n2 = JOptionPane.showOptionDialog(this, stringBuffer.toString(), "Saving to Babase", 0, 3, null, objectArray, objectArray[1]);
                bl = n2 == 0;
            } else {
                Object[] objectArray = new String[]{"Yes", "No"};
                int n = JOptionPane.showOptionDialog(this, "Are you sure you want to save it to the database?", "Saving to Babase", 0, 3, null, objectArray, objectArray[1]);
                boolean bl2 = bl = n == 0;
            }
            if (bl) {
                this._db.writeRankingInfo(this._cage.rankingId, this._cage.individuals, this._cage.ranks.get());
                this.ranksSaved();
                Utils.showMessageDialog(this, "Ranking saved to Babase!");
            }
        }
        catch (SQLException sQLException) {
            Utils.showErrorDialog(this, sQLException.getMessage());
        }
    }

    private JMenu setupFileDatabaseMenu() {
        JMenu jMenu = new JMenu("File/Database");
        jMenu.setMnemonic(70);
        JMenuItem jMenuItem = new JMenuItem("Save Ranking to Babase");
        jMenuItem.setMnemonic(83);
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!MainUI.this._db.isConnected()) {
                    MainUI.this._loginUI.start(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            MainUI.this.saveToDatabase();
                        }
                    }, new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                        }
                    });
                } else {
                    MainUI.this.saveToDatabase();
                }
            }
        });
        jMenu.add(jMenuItem);
        JMenuItem jMenuItem2 = new JMenuItem("Dump Ranker State to XML File");
        jMenuItem2.setMnemonic(68);
        jMenuItem2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (MainUI.this._xmlFileChooser.showOpenDialog(MainUI.this._this) == 0) {
                    if (MainUI.this._xmlFileChooser.getSelectedFile().exists()) {
                        Object[] objectArray = new String[]{"Yes", "No"};
                        int n = JOptionPane.showOptionDialog(MainUI.this._this, "Overwrite the existing file?", "Warning", 0, 3, null, objectArray, objectArray[1]);
                        if (n != 0) {
                            return;
                        }
                    }
                    try {
                        MainUI.this._cage.dumpToXML(MainUI.this._xmlFileChooser.getSelectedFile());
                        MainUI.this.ranksSaved();
                        Utils.showMessageDialog(MainUI.this._this, "Ranker state successfully dumped.");
                    }
                    catch (Babase.DumpToXMLException dumpToXMLException) {
                        Utils.showErrorDialog(MainUI.this._this, dumpToXMLException.getMessage());
                    }
                }
            }
        });
        jMenu.add(jMenuItem2);
        JMenuItem jMenuItem3 = new JMenuItem("Print Ranker State to Text File");
        jMenuItem3.setMnemonic(80);
        jMenuItem3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (MainUI.this._textFileChooser.showSaveDialog(MainUI.this._this) == 0) {
                    Object[] objectArray;
                    if (MainUI.this._textFileChooser.getSelectedFile().exists()) {
                        objectArray = new String[]{"Yes", "No"};
                        int n = JOptionPane.showOptionDialog(MainUI.this._this, "Overwrite the existing file?", "Warning", 0, 3, null, objectArray, objectArray[1]);
                        if (n != 0) {
                            return;
                        }
                    }
                    objectArray = null;
                    try {
                        objectArray = new PrintStream(new FileOutputStream(MainUI.this._textFileChooser.getSelectedFile(), false));
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        Utils.showErrorDialog(MainUI.this._this, "Error printing to file: " + fileNotFoundException.getMessage());
                        return;
                    }
                    MainUI.this._cage.print((PrintStream)objectArray);
                    MainUI.this._statsPanel.print((PrintStream)objectArray);
                    objectArray.close();
                    Utils.showMessageDialog(MainUI.this._this, "File successfully printed.");
                }
            }
        });
        jMenu.add(jMenuItem3);
        JMenuItem jMenuItem4 = new JMenuItem("Close Current Ranking");
        jMenuItem4.setMnemonic(67);
        jMenuItem4.setActionCommand("main.close");
        jMenuItem4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (MainUI.this.confirmClosing()) {
                    MainUI.this._actionListener.actionPerformed(actionEvent);
                }
            }
        });
        jMenu.add(jMenuItem4);
        JMenuItem jMenuItem5 = new JMenuItem("Exit");
        jMenuItem5.setMnemonic(69);
        jMenuItem5.setActionCommand("exit");
        jMenuItem5.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (MainUI.this.confirmClosing()) {
                    MainUI.this._actionListener.actionPerformed(actionEvent);
                }
            }
        });
        jMenu.add(jMenuItem5);
        return jMenu;
    }

    private void updateUI() {
        this.setVisible(false);
        float f = (float)Math.pow(1.1, this._fontSizeDelta);
        Class[] classArray = Main.CLASSES_WITH_CHANGABLE_FONT_SIZES;
        for (int i = 0; i < classArray.length; ++i) {
            Font font = (Font)UIManager.get(classArray[i].getName() + ".font.default");
            UIManager.put(classArray[i].getName() + ".font", new FontUIResource(font.deriveFont((float)font.getSize() * f)));
        }
        SwingUtilities.updateComponentTreeUI(this._this);
        this.pack();
        this.setVisible(true);
    }

    private JMenu setupRankMenu() {
        JMenu jMenu = new JMenu("Rank");
        jMenu.setMnemonic(82);
        JMenuItem jMenuItem = new JMenuItem("Load/Incorporate from Babase");
        jMenuItem.setMnemonic(76);
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                final ActionListener actionListener = new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                    }
                };
                if (!MainUI.this._db.isConnected()) {
                    MainUI.this._loginUI.start(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            MainUI.this._loadUI.start(actionListener);
                        }
                    }, new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                        }
                    });
                } else {
                    MainUI.this._loadUI.start(actionListener);
                }
            }
        });
        jMenu.add(jMenuItem);
        JMenuItem jMenuItem2 = new JMenuItem("Alphabetical");
        jMenuItem2.setMnemonic(65);
        jMenuItem2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int[] nArray = AlphabeticalAutoRanker.rank(MainUI.this._cage);
                ((MainUI)MainUI.this)._cage.ranks.permute(nArray, null);
            }
        });
        jMenu.add(jMenuItem2);
        JMenuItem jMenuItem3 = new JMenuItem("Default Rules");
        jMenuItem3.setMnemonic(68);
        jMenuItem3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int[] nArray = DefaultAutoRanker.rank(MainUI.this._cage);
                ((MainUI)MainUI.this)._cage.ranks.permute(nArray, null);
            }
        });
        jMenu.add(jMenuItem3);
        return jMenu;
    }

    private JMenu setupViewMenu() {
        JMenu jMenu = new JMenu("View");
        jMenu.setMnemonic(86);
        JMenuItem jMenuItem = new JMenuItem("Decrease Font Size");
        jMenuItem.setMnemonic(68);
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MainUI.this._fontSizeDelta--;
                MainUI.this.updateUI();
            }
        });
        jMenu.add(jMenuItem);
        JMenuItem jMenuItem2 = new JMenuItem("Reset Font Size");
        jMenuItem2.setMnemonic(82);
        jMenuItem2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MainUI.this._fontSizeDelta = 0;
                MainUI.this.updateUI();
            }
        });
        jMenu.add(jMenuItem2);
        JMenuItem jMenuItem3 = new JMenuItem("Increase Font Size");
        jMenuItem3.setMnemonic(73);
        jMenuItem3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MainUI.this._fontSizeDelta++;
                MainUI.this.updateUI();
            }
        });
        jMenu.add(jMenuItem3);
        return jMenu;
    }

    private JMenu setupHelpMenu() {
        JMenu jMenu = new JMenu("Help");
        jMenu.setMnemonic(72);
        JMenuItem jMenuItem = new JMenuItem("About");
        jMenuItem.setMnemonic(65);
        jMenuItem.setActionCommand("about");
        jMenuItem.addActionListener(this._actionListener);
        jMenu.add(jMenuItem);
        return jMenu;
    }

    public MainUI(WindowListener windowListener, ActionListener actionListener, Babase babase, Cage cage, JFileChooser jFileChooser, JFileChooser jFileChooser2, LoginUI loginUI) {
        int n;
        this.setTitle(cage.rankingId.toString() + "; " + cage.interactionSpec.toString());
        boolean bl = true;
        this._db = babase;
        this._cage = cage;
        this._textFileChooser = jFileChooser;
        this._xmlFileChooser = jFileChooser2;
        this._windowListener = windowListener;
        this._actionListener = actionListener;
        this._loginUI = loginUI;
        this._loadUI = new LoadUI(this, babase, cage);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                if (MainUI.this.confirmClosing()) {
                    MainUI.this._windowListener.windowClosing(windowEvent);
                }
            }
        });
        JMenuBar jMenuBar = new JMenuBar();
        jMenuBar.add(this.setupFileDatabaseMenu());
        jMenuBar.add(this.setupRankMenu());
        jMenuBar.add(this.setupViewMenu());
        jMenuBar.add(this.setupHelpMenu());
        this.setJMenuBar(jMenuBar);
        JPanel jPanel = new JPanel();
        this._slidableHeader = new SlidableHeader(this._cage.ranks, this._cage.individuals);
        this._swappableHeader = new SwappableHeader(this._cage.ranks, this._cage.individuals);
        this._interactionMatrixDisplay = new InteractionMatrixDisplay(this._cage.ranks, this._cage.matrix);
        int n2 = 1 + (bl ? 1 : 0) + this._cage.ranks.size();
        int n3 = 1 + (bl ? 1 : 0) + this._cage.ranks.size();
        double[] dArray = new double[n2];
        double[] dArray2 = new double[n3];
        for (n = 0; n < n2; ++n) {
            dArray[n] = -2.0;
        }
        for (n = 0; n < n3; ++n) {
            dArray2[n] = -2.0;
        }
        dArray[0] = -2.0;
        dArray2[0] = -2.0;
        if (bl) {
            dArray[1] = -2.0;
            dArray2[1] = -2.0;
        }
        jPanel.setLayout((LayoutManager)new TableLayout(dArray, dArray2));
        jPanel.add((Component)this._slidableHeader, new TableLayoutConstraints(1 + (bl ? 1 : 0), 0, n2 - 1, 0));
        jPanel.add((Component)this._swappableHeader, new TableLayoutConstraints(0, 1 + (bl ? 1 : 0), 0, n3 - 1));
        jPanel.add((Component)this._interactionMatrixDisplay, new TableLayoutConstraints(1 + (bl ? 1 : 0), 1 + (bl ? 1 : 0), n2 - 1, n3 - 1));
        if (bl) {
            for (n = 0; n < this._cage.ranks.size(); ++n) {
                jPanel.add((Component)new RankLabel(n), new TableLayoutConstraints(2 + n, 1));
                jPanel.add((Component)new RankLabel(n), new TableLayoutConstraints(1, 2 + n));
            }
        }
        JScrollPane jScrollPane = new JScrollPane(jPanel, 20, 30);
        jScrollPane.setPreferredSize(new Dimension(Toolkit.getDefaultToolkit().getScreenSize().width / 2, Toolkit.getDefaultToolkit().getScreenSize().height * 3 / 4));
        this._statsPanel = new StatsPanel(this._interactionMatrixDisplay, this._cage.ranks, this._cage.individuals, this._cage.matrix);
        this._historyPanel = new HistoryPanel(this._cage.ranks);
        JTabbedPane jTabbedPane = new JTabbedPane();
        jTabbedPane.addTab("Stats", null, this._statsPanel, "Show stats about the current ranking");
        jTabbedPane.addTab("History", null, this._historyPanel, "Show/undo history of reordering operations");
        jTabbedPane.setSelectedIndex(0);
        jTabbedPane.setMinimumSize(new Dimension(20, 20));
        jTabbedPane.setPreferredSize(this._statsPanel.getPreferredSize());
        MessagePanel messagePanel = new MessagePanel(500);
        this._out = messagePanel.getPrintStream();
        this._slidableHeader.setOut(this._out);
        this._swappableHeader.setOut(this._out);
        this._historyPanel.setOut(this._out);
        JSplitPane jSplitPane = new JSplitPane(1, jScrollPane, jTabbedPane);
        JSplitPane jSplitPane2 = new JSplitPane(0, jSplitPane, messagePanel);
        this.getContentPane().add(jSplitPane2);
        this.pack();
        this.setLocationRelativeTo(null);
        this.setVisible(true);
    }

    public void refresh() {
        this._interactionMatrixDisplay.refresh();
        this._swappableHeader.refresh();
        this._slidableHeader.refresh();
        this._statsPanel.redisplay();
    }

    public static class RankLabel
    extends JLabel {
        private static final long serialVersionUID = 1L;

        public RankLabel(int n) {
            this.setHorizontalAlignment(0);
            this.setFont((Font)UIManager.get(this.getClass().getName() + ".font"));
            this.setOpaque(true);
            this.setBackground(Color.DARK_GRAY);
            this.setForeground(Color.LIGHT_GRAY);
            this.setText(Integer.toString(n + 1));
            this.setToolTipText(Integer.toString(n + 1));
        }

        @Override
        public void updateUI() {
            super.updateUI();
            this.setFont((Font)UIManager.get(this.getClass().getName() + ".font"));
        }
    }
}

