package babase.db;

import java.util.Date;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import babase.db.Babase.LoadFromXMLException;

public class InteractionSpec {

    public final String interactionClass;

    public final Date startDate;

    public final Date endDate;

    public InteractionSpec(String interactionClass, Date startDate, Date endDate) {
        this.interactionClass = interactionClass;
        this.startDate = startDate;
        this.endDate = endDate;
        return;
    }

    public String toString() {
        return "interaction class " + interactionClass + " "
                + Babase.dateToString(startDate) + "~"
                + Babase.dateToString(endDate);
    }

    public Element toXML(Document d) {
        Element e = d.createElement("interactionSpec");
        e.setAttribute("interactionClass", interactionClass);
        e.setAttribute("startDate", Babase.dateToXMLString(startDate));
        e.setAttribute("endDate", Babase.dateToXMLString(endDate));
        return e;
    }

    public static InteractionSpec fromXML(Element e)
            throws LoadFromXMLException {
        assert (e.getNodeName().equals("interactionSpec"));
        return new InteractionSpec(e.getAttribute("interactionClass"), Babase
                .xmlStringToDate(e.getAttribute("startDate")), Babase
                .xmlStringToDate(e.getAttribute("endDate")));
    }

}
