package babase.ranker;

import java.awt.Color;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.PrintStream;

import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EtchedBorder;

import babase.ranker.ranking.Ranking;
import babase.ranker.ranking.RankingChangeEvent;
import babase.ranker.ranking.RankingChangedListener;

public class SlidableHeader extends JPanel implements RankingChangedListener,
        MouseListener {

    /**
     * Compiler-generated <code>serialVersionUID</code>.
     */
    private static final long serialVersionUID = 3186378565571657862L;

    protected static class SlidableHeaderCell extends JLabel {

        /**
         * Compiler-generated <code>serialVersionUID</code>.
         */
        private static final long serialVersionUID = 2833160457486391980L;

        protected static final Border loweredEtchedBorder = BorderFactory
                .createEtchedBorder(EtchedBorder.LOWERED);

        protected final int position;

        protected final Color defaultBackground;

        public SlidableHeaderCell(int position) {
            super();
            this.position = position;
            setHorizontalAlignment(JLabel.CENTER);
            setFont((Font) UIManager.get(getClass().getName() + ".font"));
            setBorder(loweredEtchedBorder);
            setOpaque(true);
            this.defaultBackground = getBackground();
            return;
        }
        
        public void updateUI() {
            super.updateUI();
            setFont((Font) UIManager.get(getClass().getName() + ".font"));
            return;
        }

        public void setSelected(boolean selected) {
            if (selected) {
                this.setBackground(Color.ORANGE);
            } else {
                this.setBackground(defaultBackground);
            }
            return;
        }

        public void setHeader(Header header) {
            String text = header.getText();
            String htmlToDisplay = "<html><center>";
            for (int i = 0; i < text.length(); i++) {
                if (i > 0)
                    htmlToDisplay += "<br>";
                htmlToDisplay += text.charAt(i);
            }
            htmlToDisplay += "</center></html>";
            setText(htmlToDisplay);
            setToolTipText(header.getToolTipText());
            return;
        }

    };

    protected Ranking _ranks;

    protected final Header[] _headers;

    protected SlidableHeaderCell[] _headerButtons;

    protected int _pressedPosition = -1;

    protected int _lastExitedPosition = -1;

    protected int _lastEnteredPosition = -1;

    protected PrintStream _out = System.out;

    public SlidableHeader(Ranking ranks, Header[] headers) {
        super();
        _ranks = ranks;
        _headers = headers;
        _headerButtons = new SlidableHeaderCell[_ranks.size()];

        _ranks.addChangedListener(this);
        setLayout(new GridLayout(1, _ranks.size()));
        for (int i = 0; i < _ranks.size(); i++) {
            _headerButtons[i] = new SlidableHeaderCell(i);
            _headerButtons[i].addMouseListener(this);
            add(_headerButtons[i]);
        }
        refresh();
        return;
    }

    public int getDisplayWidth() {
        return _ranks.size();
    }

    public int getDisplayHeight() {
        return Utils.findDisplayLength(_headers);
    }

    public void setOut(PrintStream out) {
        _out.flush();
        _out = out;
        return;
    }

    protected void refreshHeaderButton(int i) {
        _headerButtons[i].setHeader(_headers[_ranks.get(i)]);
        return;
    }

    public void refresh() {
        for (int i = 0; i < _ranks.size(); i++) {
            refreshHeaderButton(i);
        }
        return;
    }

    public void rankingChanged(RankingChangeEvent e) {
        if (e instanceof RankingChangeEvent.Slide) {
            RankingChangeEvent.Slide slideEvent = (RankingChangeEvent.Slide) e;
            int lower = (slideEvent.from > slideEvent.to) ? slideEvent.to
                    : slideEvent.from;
            int upper = (slideEvent.from > slideEvent.to) ? slideEvent.from
                    : slideEvent.to;
            for (int i = lower; i <= upper; i++) {
                refreshHeaderButton(i);
            }
        } else if (e instanceof RankingChangeEvent.Swap) {
            RankingChangeEvent.Swap swapEvent = (RankingChangeEvent.Swap) e;
            refreshHeaderButton(swapEvent.i);
            refreshHeaderButton(swapEvent.j);
        } else if (e instanceof RankingChangeEvent.Permute) {
            for (int i = 0; i < _ranks.size(); i++) {
                refreshHeaderButton(i);
            }
        }
        return;
    }

    public void mouseClicked(MouseEvent e) {
        return;
    }

    public void mouseEntered(MouseEvent e) {
        if (_pressedPosition == -1)
            return;
        _lastEnteredPosition = ((SlidableHeaderCell) e.getSource()).position;
        _headerButtons[_lastExitedPosition].setSelected(false);
        _headerButtons[_lastEnteredPosition].setSelected(true);
        _ranks.slide(_lastExitedPosition, _lastEnteredPosition, this);
        return;
    }

    public void mouseExited(MouseEvent e) {
        if (_pressedPosition == -1)
            return;
        _lastExitedPosition = ((SlidableHeaderCell) e.getSource()).position;
        return;
    }

    public void mousePressed(MouseEvent e) {
        assert _pressedPosition == -1;
        _pressedPosition = ((SlidableHeaderCell) e.getSource()).position;
        _headerButtons[_pressedPosition].setSelected(true);
        _out.println("Sliding "
                + _headers[_ranks.get(_pressedPosition)].getText()
                + " from rank " + (_pressedPosition + 1) + "...");
        return;
    }

    public void mouseReleased(MouseEvent e) {
        assert _pressedPosition == ((SlidableHeaderCell) e.getSource()).position;
        _headerButtons[_pressedPosition].setSelected(false);
        if (_lastEnteredPosition == -1) {
            // That means the pressed header was not dragged anywhere else:
            _out.println("Sliding cancelled");
        } else {
            _out.println("Slided "
                    + _headers[_ranks.get(_lastEnteredPosition)].getText()
                    + " from rank " + (_pressedPosition + 1) + " to "
                    + (_lastEnteredPosition + 1));
        }
        if (_lastExitedPosition != -1)
            _headerButtons[_lastExitedPosition].setSelected(false);
        if (_lastEnteredPosition != -1)
            _headerButtons[_lastEnteredPosition].setSelected(false);
        _pressedPosition = -1;
        _lastExitedPosition = -1;
        _lastEnteredPosition = -1;
        return;
    }
}
