package babase.ranker;

import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.sql.SQLException;

import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.filechooser.FileFilter;
import javax.swing.plaf.FontUIResource;

import babase.db.Babase;
import babase.ranker.InteractionMatrixDisplay.DisplayEntry;
import babase.ranker.MainUI.RankLabel;
import babase.ranker.SlidableHeader.SlidableHeaderCell;
import babase.ranker.SwappableHeader.SwappableHeaderCell;

public class Main extends WindowAdapter implements ActionListener {

    public static void main(String[] args) throws Exception {
        SwingUtilities.invokeAndWait(new Runnable() {
            public void run() {
                try {
                    new Main();
                } catch (Exception e) {
                    e.printStackTrace();
                }
                return;
            }
        });
        return;
    }

    public static final Class[] CLASSES_WITH_CHANGABLE_FONT_SIZES = {
            DisplayEntry.class, SlidableHeaderCell.class,
            SwappableHeaderCell.class, RankLabel.class };

    private final Main _this = this;

    private final Babase _db;

    private final WelcomeUI _welcomeUI;

    private final LoginUI _loginUI;

    private final AboutUI _aboutUI;

    private ChooserUI _chooserUI = null;

    private MainUI _mainUI = null;

    private final JFileChooser _textFileChooser;

    private final JFileChooser _xmlFileChooser;

    public Main() throws ClassNotFoundException, InterruptedException,
            InvocationTargetException, InstantiationException,
            IllegalAccessException, UnsupportedLookAndFeelException {

        // UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        // UIManager.setLookAndFeel("com.sun.java.swing.plaf.motif.MotifLookAndFeel");
        // UIManager.setLookAndFeel("com.sun.java.swing.plaf.gtk.GTKLookAndFeel");
        UIManager.setLookAndFeel("javax.swing.plaf.metal.MetalLookAndFeel");
        final FontUIResource[] defaultFontResources = {
                new FontUIResource("", Font.PLAIN, 10),
                new FontUIResource("", Font.PLAIN, 12),
                new FontUIResource("", Font.PLAIN, 12),
                new FontUIResource("", Font.PLAIN, 9) };
        for (int i = 0; i < CLASSES_WITH_CHANGABLE_FONT_SIZES.length; i++) {
            UIManager.put(CLASSES_WITH_CHANGABLE_FONT_SIZES[i].getName()
                    + ".font.default", defaultFontResources[i]);
            UIManager.put(CLASSES_WITH_CHANGABLE_FONT_SIZES[i].getName()
                    + ".font", defaultFontResources[i]);
        }

        _db = new Babase();
        _welcomeUI = new WelcomeUI(this, this);
        _loginUI = new LoginUI(_db);
        _aboutUI = new AboutUI();
        _textFileChooser = new JFileChooser();
        _textFileChooser.setDialogTitle("Select a .txt file");
        _textFileChooser.addChoosableFileFilter(new FileFilter() {
            public boolean accept(File f) {
                if (f.isDirectory())
                    return true;
                String name = f.getName();
                int i = name.lastIndexOf('.');
                if (i > 0 && i < name.length() - 1)
                    return name.substring(i + 1).toLowerCase().equals("txt");
                else
                    return false;
            }

            public String getDescription() {
                return "Babase Ranker State Print-Out (.txt)";
            }
        });
        _xmlFileChooser = new JFileChooser();
        _xmlFileChooser.setDialogTitle("Select a .xml file");
        _xmlFileChooser.addChoosableFileFilter(new FileFilter() {
            public boolean accept(File f) {
                if (f.isDirectory())
                    return true;
                String name = f.getName();
                int i = name.lastIndexOf('.');
                if (i > 0 && i < name.length() - 1)
                    return name.substring(i + 1).toLowerCase().equals("xml");
                else
                    return false;
            }

            public String getDescription() {
                return "Babase Ranker State Dump File (.xml)";
            }
        });
        _welcomeUI.setVisible(true);
        return;
    }

    public void exit() {
        System.exit(0);
    }

    public void windowClosing(WindowEvent e) {
        exit();
    }

    private void newChooserUI() {
        try {
            _chooserUI = new ChooserUI(_db, _this, _this);
        } catch (SQLException sqlException) {
            _chooserUI = null;
            _welcomeUI.setVisible(true);
            JOptionPane.showMessageDialog(_welcomeUI, sqlException.getMessage()
                    + "\n");
        }
        _chooserUI.setVisible(true);
        return;
    }

    public void actionPerformed(ActionEvent e) {
        if ("welcome.create".equals(e.getActionCommand())) {
            _welcomeUI.setVisible(false);
            if (!_db.isConnected()) {
                _loginUI.start(new ActionListener() {
                    public void actionPerformed(ActionEvent e) {
                        newChooserUI();
                        return;
                    }
                }, new ActionListener() {
                    public void actionPerformed(ActionEvent e) {
                        _welcomeUI.setVisible(true);
                        return;
                    }
                });
            } else {
                newChooserUI();
            }
        } else if ("welcome.restore".equals(e.getActionCommand())) {
            if (_xmlFileChooser.showOpenDialog(_welcomeUI) == JFileChooser.APPROVE_OPTION) {
                Cage cage = null;
                try {
                    cage = Cage.loadFromXML(_xmlFileChooser.getSelectedFile());
                } catch (Exception cageException) {
                    Utils.showErrorDialog(_xmlFileChooser,
                            "Error restoring from file!");
                }
                if (cage != null) {
                    _welcomeUI.setVisible(false);
                    _mainUI = new MainUI(this, this, _db, cage,
                            _textFileChooser, _xmlFileChooser, _loginUI);
                    _mainUI.ranksSaved();
                    _mainUI.setVisible(true);
                }
            }
        } else if ("chooser.rank".equals(e.getActionCommand())) {
            Cage cage = _chooserUI.createCage(_db);
            if (cage != null) {
                _chooserUI.setVisible(false);
                _mainUI = new MainUI(this, this, _db, cage, _textFileChooser,
                        _xmlFileChooser, _loginUI);
                _mainUI.setVisible(true);
            }
        } else if ("chooser.cancel".equals(e.getActionCommand())) {
            _chooserUI.setVisible(false);
            _welcomeUI.setVisible(true);
        } else if ("main.close".equals(e.getActionCommand())) {
            _mainUI.dispose();
            _mainUI = null;
            _welcomeUI.setVisible(true);
        } else if ("about".equals(e.getActionCommand())) {
            _aboutUI.setVisible(true);
        } else if ("exit".equals(e.getActionCommand())) {
            exit();
        }
        return;
    }

}
