package babase.db;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class RankType {

    public final String type;

    public final String description;

    public RankType(String type, String description) {
        this.type = type;
        this.description = description;
    }

    public String toString() {
        return type + ((description == null) ? "" : (" (" + description + ")"));
    }

    public String toSQLLiteral() {
        return "'" + type + "'";
    }

    public Element toXML(Document d) {
        Element e = d.createElement("rankType");
        e.setAttribute("type", type);
        e.setAttribute("description", description);
        return e;
    }

    public static RankType fromXML(Element e) {
        assert (e.getNodeName().equals("rankType"));
        return new RankType(e.getAttribute("type"), e
                .getAttribute("description"));
    }

    public static int findRankType(RankType[] rankTypes, RankType rankType) {
        for (int i=0; i<rankTypes.length; i++) {
            if (rankTypes[i].type.equals(rankType.type))
                return i;
        }
        return -1;
    }
}
