package babase.ranker;

import java.awt.Component;

import javax.swing.JDialog;
import javax.swing.JOptionPane;

public class Utils {

    /**
     * @param headers
     *            The list of headers.
     * @return The minimum number of charaters needed to display each header
     *         completely.
     */
    public static int findDisplayLength(Header[] headers) {
        int maxDisplayLength = 0;
        for (int i = 0; i < headers.length; i++) {
            int thisHeaderLength = headers[i].getText().length();
            if (thisHeaderLength > maxDisplayLength)
                maxDisplayLength = thisHeaderLength;
        }
        return maxDisplayLength;
    }

    private static class NarrowOptionPane extends JOptionPane {
        private static final long serialVersionUID = 1L;

        int _maxCharactersPerLineCount;

        public NarrowOptionPane(int maxCharactersPerLineCount) {
            _maxCharactersPerLineCount = maxCharactersPerLineCount;
        }

        public int getMaxCharactersPerLineCount() {
            return _maxCharactersPerLineCount;
        }
    }

    private static NarrowOptionPane _narrowOptionPane = new NarrowOptionPane(40);

    public static JDialog showMessageDialog(Component c, String message) {
        return showMessageDialog(c, message, "Message", JOptionPane.INFORMATION_MESSAGE);
    }

    public static JDialog showErrorDialog(Component c, String message) {
        return showMessageDialog(c, message, "Error", JOptionPane.ERROR_MESSAGE);
    }

    public static JDialog showMessageDialog(Component c, String message,
            String title, int messageType) {
        _narrowOptionPane.setMessage(message);
        _narrowOptionPane.setMessageType(messageType);
        JDialog dialog = _narrowOptionPane.createDialog(c, title);
        dialog.setVisible(true);
        return dialog;
    }

}
