package babase.ranker;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridLayout;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.WindowListener;

import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class WelcomeUI extends JFrame {

    private static final long serialVersionUID = 1L;

    public WelcomeUI(WindowListener windowListener,
            ActionListener actionListener) {

        setTitle("Welcome");
        setDefaultCloseOperation(JFrame.DO_NOTHING_ON_CLOSE);
        addWindowListener(windowListener);

        JLabel textLabel = new JLabel("Babase Ranker v1.1");
        textLabel.setAlignmentX(Component.CENTER_ALIGNMENT);

        Container buttonPanel = new JPanel(new GridLayout(0, 1));
        JButton fromDBButton = new JButton("Create/load ranking from Babase");
        fromDBButton.setMnemonic(KeyEvent.VK_C);
        fromDBButton.setActionCommand("welcome.create");
        fromDBButton.addActionListener(actionListener);
        buttonPanel.add(fromDBButton);
        JButton fromFileButton = new JButton("Restore ranker state from XML file");
        fromFileButton.setMnemonic(KeyEvent.VK_R);
        fromFileButton.setActionCommand("welcome.restore");
        fromFileButton.addActionListener(actionListener);
        fromFileButton.setAlignmentX(Component.CENTER_ALIGNMENT);
        buttonPanel.add(fromFileButton);
        JButton aboutButton = new JButton("About");
        aboutButton.setMnemonic(KeyEvent.VK_A);
        aboutButton.setActionCommand("about");
        aboutButton.addActionListener(actionListener);
        aboutButton.setAlignmentX(Component.CENTER_ALIGNMENT);
        buttonPanel.add(aboutButton);
        JButton exitButton = new JButton("Exit");
        exitButton.setMnemonic(KeyEvent.VK_E);
        exitButton.setActionCommand("exit");
        exitButton.addActionListener(actionListener);
        exitButton.setAlignmentX(Component.CENTER_ALIGNMENT);
        buttonPanel.add(exitButton);

        getContentPane().setLayout(
                new BoxLayout(getContentPane(), BoxLayout.Y_AXIS));
        getContentPane().add(textLabel);
        getContentPane().add(buttonPanel);

        setResizable(false);
        pack();
        setLocationRelativeTo(null);
        return;
    }

}
