package babase.db;

import java.math.BigDecimal;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Group {

    public final BigDecimal number;

    public final String name;

    public Group(BigDecimal number, String name) {
        this.number = number;
        this.name = name;
    }

    public String toString() {
        return number.toString() + ((name == null) ? "" : (" (" + name + ")"));
    }

    public String toSQLLiteral() {
        return number.toString();
    }

    public String toXMLString() {
        return number.toString();
    }

    public Element toXML(Document d) {
        Element e = d.createElement("group");
        e.setAttribute("number", number.toString());
        e.setAttribute("name", name);
        return e;
    }

    public static Group fromXML(Element e) {
        assert (e.getNodeName().equals("group"));
        return new Group(new BigDecimal(e.getAttribute("number")), e
                .getAttribute("name"));
    }
    
    public static int findGroup(Group[] groups, Group group) {
        for (int i=0; i<groups.length; i++) {
            if (groups[i].number.equals(group.number))
                return i;
        }
        return -1;
    }
}