package babase.ranker.auto;

import java.util.Arrays;
import java.util.Comparator;

import babase.ranker.Cage;

public class AlphabeticalAutoRanker {

    public static int[] rank(final Cage cage) {
        Integer[] newRank = new Integer[cage.ranks.size()];
        for (int i = 0; i < cage.ranks.size(); i++) {
            newRank[i] = cage.ranks.get(i);
        }
        Arrays.sort(newRank, new Comparator<Integer>() {
            public int compare(Integer i, Integer j) {
                return cage.individuals[i].sname
                        .compareTo(cage.individuals[j].sname);
            }
        });
        int[] newIntRank = new int[newRank.length];
        for (int i = 0; i < newRank.length; i++)
            newIntRank[i] = newRank[i].intValue();
        return newIntRank;
    }

}
