/*
 * Decompiled with CFR 0.152.
 */
package babase.db;

import babase.db.Group;
import babase.db.Individual;
import babase.db.InteractionSpec;
import babase.db.RankType;
import babase.db.RankingIdentifier;
import babase.db.RankingInfo;
import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Properties;
import java.util.Vector;

public class Babase {
    private Connection _connection = null;
    private ArrayList<Group> _cachedGroups = null;
    private ArrayList<String> _cachedClasses = null;
    private ArrayList<RankType> _cachedRankTypes = null;

    public static String dateToString(java.util.Date date) {
        return new SimpleDateFormat("yyyy-MM-dd").format(date);
    }

    public static String datetimeToString(java.util.Date date) {
        return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss EEE").format(date);
    }

    public static String dateToXMLString(java.util.Date date) {
        return new SimpleDateFormat("yyyy-MM-dd").format(date);
    }

    public static boolean isStartOfMonth(java.util.Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.get(5) == 1;
    }

    public static boolean isEndOfMonth(java.util.Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int n = calendar.get(2);
        calendar.add(5, 1);
        return n != calendar.get(2);
    }

    public static boolean isInSameMonth(java.util.Date date, java.util.Date date2) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int n = calendar.get(1);
        int n2 = calendar.get(2);
        calendar.setTime(date2);
        int n3 = calendar.get(1);
        int n4 = calendar.get(2);
        return n == n3 && n2 == n4;
    }

    public static java.util.Date endOfMonth(java.util.Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(2, 1);
        calendar.set(5, 1);
        calendar.add(5, -1);
        return calendar.getTime();
    }

    public static java.util.Date xmlStringToDate(String string) throws LoadFromXMLException {
        try {
            return new SimpleDateFormat("yyyy-MM-dd").parse(string);
        }
        catch (ParseException parseException) {
            throw new LoadFromXMLException("'" + string + "' is not formatted correctly as a date", parseException);
        }
    }

    private static String dateToSQLLiteral(java.util.Date date) {
        return "'" + new SimpleDateFormat("yyyy-MM-dd").format(date) + "'";
    }

    public Babase() throws ClassNotFoundException {
        Class.forName("org.postgresql.Driver");
    }

    public void connect(String string, String string2, String string3, String string4, String string5, Boolean bl) throws SQLException {
        if (this._connection != null) {
            this.disconnect();
        }
        Properties properties = new Properties();
        properties.setProperty("user", string3);
        properties.setProperty("password", string4);
        if (bl.booleanValue()) {
            properties.setProperty("ssl", "true");
            properties.setProperty("sslfactory", "org.postgresql.ssl.NonValidatingFactory");
        }
        this._connection = DriverManager.getConnection("jdbc:postgresql://" + string + ":" + string2 + "/" + string5, properties);
    }

    public boolean isConnected() {
        return this._connection != null;
    }

    public void disconnect() throws SQLException {
        this._connection.close();
        this._connection = null;
        this._cachedGroups = null;
        this._cachedClasses = null;
        this._cachedRankTypes = null;
    }

    public RankType[] getRankTypes() throws SQLException {
        if (this._cachedRankTypes == null) {
            ArrayList<RankType> arrayList = new ArrayList<RankType>();
            Statement statement = this._connection.createStatement();
            ResultSet resultSet = statement.executeQuery("SELECT DISTINCT rnktype, descr FROM rnktypes ORDER BY rnktype");
            while (resultSet.next()) {
                arrayList.add(new RankType(resultSet.getString(1), resultSet.getString(2)));
            }
            resultSet.close();
            statement.close();
            this._cachedRankTypes = arrayList;
        }
        return this._cachedRankTypes.toArray(new RankType[this._cachedRankTypes.size()]);
    }

    public Group[] getGroups() throws SQLException {
        if (this._cachedGroups == null) {
            ArrayList<Group> arrayList = new ArrayList<Group>();
            Statement statement = this._connection.createStatement();
            ResultSet resultSet = statement.executeQuery("SELECT DISTINCT gid, name FROM groups ORDER BY gid;");
            while (resultSet.next()) {
                arrayList.add(new Group(resultSet.getBigDecimal(1), resultSet.getString(2)));
            }
            resultSet.close();
            statement.close();
            this._cachedGroups = arrayList;
        }
        return this._cachedGroups.toArray(new Group[this._cachedGroups.size()]);
    }

    public String[] getInteractionClasses() throws SQLException {
        if (this._cachedClasses == null) {
            ArrayList<String> arrayList = new ArrayList<String>();
            Statement statement = this._connection.createStatement();
            ResultSet resultSet = statement.executeQuery("SELECT DISTINCT class FROM acts ORDER BY class;");
            while (resultSet.next()) {
                arrayList.add(resultSet.getString(1));
            }
            resultSet.close();
            statement.close();
            this._cachedClasses = arrayList;
        }
        return this._cachedClasses.toArray(new String[this._cachedClasses.size()]);
    }

    public String getSnamesToRankQuery(RankingIdentifier rankingIdentifier) throws SQLException {
        Statement statement = this._connection.createStatement();
        ResultSet resultSet = statement.executeQuery("SELECT query FROM rnktypes WHERE rnktype = " + rankingIdentifier.rankType.toSQLLiteral());
        resultSet.next();
        String string = resultSet.getString(1);
        resultSet.close();
        statement.close();
        string = string.replace("%s", Babase.dateToSQLLiteral(rankingIdentifier.startDate));
        string = string.replace("%f", Babase.dateToSQLLiteral(rankingIdentifier.endDate));
        string = string.replace("%g", rankingIdentifier.group.toSQLLiteral());
        return string;
    }

    public Individual[] getIndividuals(RankingIdentifier rankingIdentifier) throws SQLException {
        String string = this.getSnamesToRankQuery(rankingIdentifier);
        Statement statement = this._connection.createStatement();
        ResultSet resultSet = statement.executeQuery("SELECT bioid, sname, name, pid, birth, bstatus, sex, matgrp, statdate, status, dcause, dcauseconfidence, (SELECT MIN(matured) FROM maturedates WHERE sname = biograph.sname), (SELECT MIN(ranked) FROM rankdates WHERE sname = biograph.sname) FROM biograph WHERE sname IN (" + string + ") ORDER BY sname");
        ArrayList<Individual> arrayList = new ArrayList<Individual>();
        while (resultSet.next()) {
            arrayList.add(new Individual(resultSet.getString(2), resultSet.getObject(1) == null ? null : new Integer(resultSet.getInt(1)), resultSet.getString(3), resultSet.getString(4), resultSet.getDate(5), resultSet.getObject(6) == null ? null : new Integer(resultSet.getInt(6)), resultSet.getString(7) == null ? null : Character.valueOf(resultSet.getString(7).toCharArray()[0]), resultSet.getBigDecimal(8), resultSet.getDate(9), resultSet.getObject(10) == null ? null : new Integer(resultSet.getInt(10)), resultSet.getObject(11) == null ? null : new Integer(resultSet.getInt(11)), resultSet.getObject(12) == null ? null : new Integer(resultSet.getInt(12)), resultSet.getDate(13), resultSet.getDate(14)));
        }
        resultSet.close();
        statement.close();
        return arrayList.toArray(new Individual[arrayList.size()]);
    }

    public int[][] getInteractionMatrix(RankingIdentifier rankingIdentifier, InteractionSpec interactionSpec, Individual[] individualArray) throws SQLException {
        String string = this.getSnamesToRankQuery(rankingIdentifier);
        int[][] nArray = new int[individualArray.length][individualArray.length];
        int n = 0;
        while (n < individualArray.length) {
            int n2 = 0;
            while (n2 < individualArray.length) {
                nArray[n][n2] = 0;
                ++n2;
            }
            ++n;
        }
        Statement statement = this._connection.createStatement();
        ResultSet resultSet = statement.executeQuery("SELECT actor, actee, COUNT(*) FROM actor_actees WHERE actor IN (" + string + ")" + " AND actee IN (" + string + ")" + " AND date >= " + Babase.dateToSQLLiteral(interactionSpec.startDate) + " AND date <= " + Babase.dateToSQLLiteral(interactionSpec.endDate) + " AND act IN (SELECT act FROM acts WHERE class = '" + interactionSpec.interactionClass + "') " + " GROUP BY actor, actee");
        while (resultSet.next()) {
            String string2 = resultSet.getString(1);
            String string3 = resultSet.getString(2);
            int n3 = resultSet.getInt(3);
            int n4 = Individual.findIndividualBySname(string2, individualArray);
            int n5 = Individual.findIndividualBySname(string3, individualArray);
            assert (n4 != -1 && n5 != -1);
            nArray[n4][n5] = n3;
        }
        return nArray;
    }

    public void writeRankingInfo(RankingIdentifier rankingIdentifier, Individual[] individualArray, int[] nArray) throws SQLException {
        assert (Babase.isStartOfMonth(rankingIdentifier.startDate) && Babase.isEndOfMonth(rankingIdentifier.endDate) && Babase.isInSameMonth(rankingIdentifier.startDate, rankingIdentifier.endDate));
        boolean bl = this._connection.getAutoCommit();
        this._connection.setAutoCommit(false);
        Statement statement = this._connection.createStatement();
        statement.executeUpdate("DELETE FROM ranks WHERE rnkdate = " + Babase.dateToSQLLiteral(rankingIdentifier.startDate) + " AND grp = " + rankingIdentifier.group.toSQLLiteral() + " AND rnktype = " + rankingIdentifier.rankType.toSQLLiteral());
        int n = 0;
        while (n < nArray.length) {
            String string = individualArray[nArray[n]].sname;
            statement.executeUpdate("INSERT INTO ranks(rnkdate, grp, rnktype, sname, rank) VALUES (" + Babase.dateToSQLLiteral(rankingIdentifier.startDate) + ", " + rankingIdentifier.group.toSQLLiteral() + ", " + rankingIdentifier.rankType.toSQLLiteral() + ", '" + string + "', " + (n + 1) + ")");
            ++n;
        }
        this._connection.commit();
        this._connection.setAutoCommit(bl);
    }

    public RankingInfo getRankingInfo(RankingIdentifier rankingIdentifier) throws SQLException {
        if (!(Babase.isStartOfMonth(rankingIdentifier.startDate) && Babase.isEndOfMonth(rankingIdentifier.endDate) && Babase.isInSameMonth(rankingIdentifier.startDate, rankingIdentifier.endDate))) {
            return null;
        }
        Statement statement = this._connection.createStatement();
        ResultSet resultSet = statement.executeQuery("SELECT sname, rank FROM ranks WHERE grp = " + rankingIdentifier.group.toSQLLiteral() + " AND rnktype = " + rankingIdentifier.rankType.toSQLLiteral() + " AND rnkdate = " + Babase.dateToSQLLiteral(rankingIdentifier.startDate) + " ORDER BY ranks.rank");
        Vector<String> vector = new Vector<String>();
        Vector<Integer> vector2 = new Vector<Integer>();
        while (resultSet.next()) {
            vector.add(resultSet.getString(1));
            vector2.add(resultSet.getInt(2) - 1);
        }
        return vector.isEmpty() ? null : new RankingInfo(rankingIdentifier, vector, vector2);
    }

    public java.util.Date getLatestRankingDateSaved(RankingIdentifier rankingIdentifier) throws SQLException {
        Statement statement = this._connection.createStatement();
        ResultSet resultSet = statement.executeQuery("SELECT MAX(rnkdate) FROM ranks WHERE grp = " + rankingIdentifier.group.toSQLLiteral() + " AND rnktype = " + rankingIdentifier.rankType.toSQLLiteral() + " AND rnkdate <= " + Babase.dateToSQLLiteral(rankingIdentifier.startDate));
        Date date = null;
        while (resultSet.next()) {
            date = resultSet.getDate(1);
        }
        resultSet.close();
        statement.close();
        return date;
    }

    public static class DumpToXMLException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public DumpToXMLException(String string) {
            super(string);
        }

        public DumpToXMLException(String string, Throwable throwable) {
            super(string, throwable);
        }
    }

    public static class LoadFromXMLException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public LoadFromXMLException(String string) {
            super(string);
        }

        public LoadFromXMLException(String string, Throwable throwable) {
            super(string, throwable);
        }
    }
}

