/*
 * Decompiled with CFR 0.152.
 */
package babase.db;

import java.math.BigDecimal;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Group {
    public final BigDecimal number;
    public final String name;

    public Group(BigDecimal bigDecimal, String string) {
        this.number = bigDecimal;
        this.name = string;
    }

    public String toString() {
        return String.valueOf(this.number.toString()) + (this.name == null ? "" : " (" + this.name + ")");
    }

    public String toSQLLiteral() {
        return this.number.toString();
    }

    public String toXMLString() {
        return this.number.toString();
    }

    public Element toXML(Document document) {
        Element element = document.createElement("group");
        element.setAttribute("number", this.number.toString());
        element.setAttribute("name", this.name);
        return element;
    }

    public static Group fromXML(Element element) {
        assert (element.getNodeName().equals("group"));
        return new Group(new BigDecimal(element.getAttribute("number")), element.getAttribute("name"));
    }

    public static int findGroup(Group[] groupArray, Group group) {
        int n = 0;
        while (n < groupArray.length) {
            if (groupArray[n].number.equals(group.number)) {
                return n;
            }
            ++n;
        }
        return -1;
    }
}

