/*
 * Decompiled with CFR 0.152.
 */
package babase.ranker;

import babase.db.Babase;
import babase.db.Group;
import babase.db.Individual;
import babase.db.InteractionSpec;
import babase.db.RankType;
import babase.db.RankingIdentifier;
import babase.db.RankingInfo;
import babase.ranker.Cage;
import babase.ranker.IncorporatorUI;
import babase.ranker.Utils;
import babase.ranker.auto.DefaultAutoRanker;
import com.toedter.calendar.JDateChooser;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.awt.event.WindowListener;
import java.sql.SQLException;
import java.util.Date;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class ChooserUI
extends JFrame {
    private static final long serialVersionUID = 1L;
    private JComboBox rankTypeBox;
    private JComboBox groupBox;
    private JDateChooser rankStartDateChooser;
    private JDateChooser rankEndDateChooser;
    private JComboBox interactionClassChooser;
    private JDateChooser interactionStartDateChooser;
    private JDateChooser interactionEndDateChooser;

    public ChooserUI(Babase babase, WindowListener windowListener, ActionListener actionListener) throws SQLException {
        this.setTitle("Ranking from database");
        this.setDefaultCloseOperation(0);
        this.addWindowListener(windowListener);
        this.rankTypeBox = new JComboBox<RankType>(babase.getRankTypes());
        this.groupBox = new JComboBox<Group>(babase.getGroups());
        this.rankStartDateChooser = new JDateChooser("yyyy-MM-dd", "####-##-##", '_');
        this.rankEndDateChooser = new JDateChooser("yyyy-MM-dd", "####-##-##", '_');
        this.interactionClassChooser = new JComboBox<String>(babase.getInteractionClasses());
        this.interactionStartDateChooser = new JDateChooser("yyyy-MM-dd", "####-##-##", '_');
        this.interactionEndDateChooser = new JDateChooser("yyyy-MM-dd", "####-##-##", '_');
        JPanel jPanel = new JPanel(new GridBagLayout());
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 0, 5, 0);
        jPanel2.add((Component)new JLabel("Please specify the following information:"), gridBagConstraints);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.insets = new Insets(10, 10, 0, 10);
        jPanel.add((Component)new JLabel("Rank type: "), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.insets = new Insets(10, 0, 0, 10);
        jPanel.add((Component)this.rankTypeBox, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.insets = new Insets(10, 10, 0, 10);
        jPanel.add((Component)new JLabel("Group: "), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.insets = new Insets(10, 0, 0, 10);
        jPanel.add((Component)this.groupBox, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        gridBagConstraints.gridwidth = 1;
        jPanel.add((Component)new JLabel("Ranking start date: "), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.insets = new Insets(10, 0, 0, 10);
        jPanel.add((Component)this.rankStartDateChooser, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        jPanel.add((Component)new JLabel("Ranking end date: "), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.insets = new Insets(10, 0, 0, 10);
        jPanel.add((Component)this.rankEndDateChooser, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        gridBagConstraints.gridwidth = 1;
        jPanel.add((Component)new JLabel("Interaction class: "), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.insets = new Insets(10, 0, 0, 10);
        jPanel.add((Component)this.interactionClassChooser, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        gridBagConstraints.gridwidth = 1;
        jPanel.add((Component)new JLabel("Interaction start date: "), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.insets = new Insets(10, 0, 0, 10);
        jPanel.add((Component)this.interactionStartDateChooser, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        jPanel.add((Component)new JLabel("Interaction end date: "), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.insets = new Insets(10, 0, 0, 10);
        jPanel.add((Component)this.interactionEndDateChooser, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.insets = new Insets(10, 10, 5, 10);
        JButton jButton = new JButton("Cancel");
        jButton.setActionCommand("chooser.cancel");
        jButton.addActionListener(actionListener);
        jButton.setMnemonic(67);
        jPanel.add((Component)jButton, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.insets = new Insets(10, 10, 5, 10);
        JButton jButton2 = new JButton("Rank");
        jButton2.setActionCommand("chooser.rank");
        jButton2.addActionListener(actionListener);
        jButton2.setMnemonic(82);
        jPanel.add((Component)jButton2, gridBagConstraints);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)jPanel2, "North");
        this.getContentPane().add((Component)jPanel, "South");
        this.setResizable(false);
        this.pack();
        this.setLocationRelativeTo(null);
        this.getRootPane().setDefaultButton(jButton2);
    }

    public Cage createCage(Babase babase) {
        Object[] objectArray;
        Individual[] individualArray;
        InteractionSpec interactionSpec;
        Object object;
        Cage cage;
        block10: {
            int n;
            cage = null;
            RankType rankType = (RankType)this.rankTypeBox.getSelectedItem();
            Group group = (Group)this.groupBox.getSelectedItem();
            Date date = this.rankStartDateChooser.getDate();
            Date date2 = this.rankEndDateChooser.getDate();
            String string = (String)this.interactionClassChooser.getSelectedItem();
            Date date3 = this.interactionStartDateChooser.getDate();
            Date date4 = this.interactionEndDateChooser.getDate();
            if (date == null || date2 == null || !date.before(date2)) {
                JOptionPane.showMessageDialog(this, "Please enter a valid date range for the ranking!");
                return null;
            }
            if (!(Babase.isStartOfMonth(date) && Babase.isEndOfMonth(date2) && Babase.isInSameMonth(date, date2) || (n = JOptionPane.showOptionDialog(this, "Ranking does not start and end on the first and the last days\nof the same month; you will NOT be able to save it in Babase\n(but it still can be saved as XML or printed as text).", null, 0, 2, null, object = new String[]{"Proceed", "Cancel"}, object[0])) != 1)) {
                return null;
            }
            if (date3 == null || date4 == null || !date3.before(date4)) {
                JOptionPane.showMessageDialog(this, "Please enter a valid date range for the interaction matrix!");
                return null;
            }
            try {
                object = new RankingIdentifier(group, rankType, date, date2);
                interactionSpec = new InteractionSpec(string, date3, date4);
                individualArray = babase.getIndividuals((RankingIdentifier)object);
                if (individualArray.length >= 1) break block10;
                Utils.showMessageDialog(this, "There are no individuals to rank between the ranking start and end dates!");
                return null;
            }
            catch (SQLException sQLException) {
                JOptionPane.showMessageDialog(this, sQLException.getMessage());
                return null;
            }
        }
        int[][] nArray = babase.getInteractionMatrix((RankingIdentifier)object, interactionSpec, individualArray);
        cage = new Cage((RankingIdentifier)object, interactionSpec, individualArray, nArray);
        cage.ranks.permute(DefaultAutoRanker.rank(cage), null);
        Date date = babase.getLatestRankingDateSaved((RankingIdentifier)object);
        String string = "Initializing ranking";
        if (date == null) {
            String string2 = "<html>Babase has no exiting ranking for " + object + " or before.<br>" + "Ranking will be initialized using default rules." + "</html>";
            Object[] objectArray2 = new String[]{"Proceed", "Cancel"};
            int n = JOptionPane.showOptionDialog(this, string2, string, 0, 3, null, objectArray2, objectArray2[0]);
            return n == 0 ? cage : null;
        }
        if (date.equals(cage.rankingId.startDate) && Babase.isEndOfMonth(cage.rankingId.endDate) && Babase.isInSameMonth(cage.rankingId.startDate, cage.rankingId.endDate)) {
            Object[] objectArray3;
            String string3 = "<html>Babase has an existing ranking for " + object + ".<br>" + "Load the existing ranking, or initalize using default rules?" + "</html>";
            int n = JOptionPane.showOptionDialog(this, string3, string, 1, 3, null, objectArray3 = new String[]{"Load", "Default", "Cancel"}, objectArray3[0]);
            if (n == 0) {
                RankingInfo rankingInfo = babase.getRankingInfo(cage.rankingId);
                IncorporatorUI.incorporate(this, "Inconsistency with existing ranking", cage, rankingInfo, true);
                return cage;
            }
            return n == 1 ? cage : null;
        }
        String string4 = "<html>Babase has no existing ranking for " + object + ";<br>" + "the closest preceding ranking is for " + Babase.dateToString(date) + ".<br>" + "After initalizing ranking using default rules,<br>" + "would you like to incorporate the preceding ranking?" + "</html>";
        int n = JOptionPane.showOptionDialog(this, string4, string, 1, 3, null, objectArray = new String[]{"Yes", "No", "Cancel"}, objectArray[0]);
        if (n == 0) {
            RankingInfo rankingInfo = babase.getRankingInfo(new RankingIdentifier(cage.rankingId.group, cage.rankingId.rankType, date));
            IncorporatorUI.incorporate(this, "Incorporate previous ranking", cage, rankingInfo, false);
            return cage;
        }
        return n == 1 ? cage : null;
    }
}

