/*
 * Decompiled with CFR 0.152.
 */
package babase.ranker;

import babase.ranker.ranking.Ranking;
import babase.ranker.ranking.RankingChangeEvent;
import babase.ranker.ranking.RankingChangedListener;
import java.awt.Color;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Insets;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.UIManager;

public class InteractionMatrixDisplay
extends JPanel
implements RankingChangedListener {
    private static final long serialVersionUID = 3799732940123199825L;
    private final Ranking _ranks;
    private final int[][] _matrix;
    private final DisplayEntry[][] _displayEntries;
    private final ButtonGroup _displayGroup;
    private final JToggleButton _displayNoneSelected;

    public InteractionMatrixDisplay(Ranking ranking, int[][] nArray) {
        this._ranks = ranking;
        this._matrix = nArray;
        this._displayEntries = new DisplayEntry[this._ranks.size()][this._ranks.size()];
        this._displayGroup = new ButtonGroup();
        this._displayNoneSelected = new JToggleButton();
        this._ranks.addChangedListener(this);
        this.setLayout(new GridLayout(this._ranks.size(), this._ranks.size()));
        int n = 0;
        while (n < this._ranks.size()) {
            int n2 = 0;
            while (n2 < this._ranks.size()) {
                this._displayEntries[n][n2] = new DisplayEntry(n, n2);
                this.add(this._displayEntries[n][n2]);
                this._displayGroup.add(this._displayEntries[n][n2]);
                ++n2;
            }
            ++n;
        }
        this._displayGroup.add(this._displayNoneSelected);
        this.refresh();
    }

    public Ranking getRanks() {
        return this._ranks;
    }

    public int getDisplayCellWidth() {
        int n = 0;
        int n2 = 0;
        while (n2 < this._matrix.length) {
            int n3 = 0;
            while (n3 < this._matrix[n2].length) {
                if (Integer.toString(this._matrix[n2][n3]).length() > n) {
                    n = Integer.toString(this._matrix[n2][n3]).length();
                }
                ++n3;
            }
            ++n2;
        }
        return n;
    }

    public int getDisplayCellHeight() {
        return 1;
    }

    public void selectDisplayEntry(int n, int n2) {
        this._displayEntries[n][n2].setSelected(true);
    }

    private void refreshDisplayEntry(int n, int n2) {
        if (this._displayEntries[n][n2].isSelected()) {
            this._displayNoneSelected.setSelected(true);
        }
        this._displayEntries[n][n2].setValue(this._matrix[this._ranks.get(n)][this._ranks.get(n2)]);
    }

    public void refresh() {
        int n = 0;
        while (n < this._ranks.size()) {
            int n2 = 0;
            while (n2 < this._ranks.size()) {
                this.refreshDisplayEntry(n, n2);
                ++n2;
            }
            ++n;
        }
    }

    public void rankingChanged(RankingChangeEvent rankingChangeEvent) {
        if (rankingChangeEvent instanceof RankingChangeEvent.Slide) {
            int n;
            RankingChangeEvent.Slide slide = (RankingChangeEvent.Slide)rankingChangeEvent;
            int n2 = slide.from > slide.to ? slide.to : slide.from;
            int n3 = slide.from > slide.to ? slide.from : slide.to;
            int n4 = 0;
            while (n4 < this._ranks.size()) {
                n = n2;
                while (n <= n3) {
                    this.refreshDisplayEntry(n4, n);
                    ++n;
                }
                ++n4;
            }
            n4 = n2;
            while (n4 <= n3) {
                n = 0;
                while (n < n2) {
                    this.refreshDisplayEntry(n4, n);
                    ++n;
                }
                n = n3 + 1;
                while (n < this._ranks.size()) {
                    this.refreshDisplayEntry(n4, n);
                    ++n;
                }
                ++n4;
            }
        } else if (rankingChangeEvent instanceof RankingChangeEvent.Swap) {
            int n = ((RankingChangeEvent.Swap)rankingChangeEvent).i;
            int n5 = ((RankingChangeEvent.Swap)rankingChangeEvent).j;
            int n6 = 0;
            while (n6 < this._ranks.size()) {
                this.refreshDisplayEntry(n, n6);
                this.refreshDisplayEntry(n5, n6);
                ++n6;
            }
            n6 = 0;
            while (n6 < this._ranks.size()) {
                if (n6 != n && n6 != n5) {
                    this.refreshDisplayEntry(n6, n);
                    this.refreshDisplayEntry(n6, n5);
                }
                ++n6;
            }
        } else if (rankingChangeEvent instanceof RankingChangeEvent.Permute) {
            this.refresh();
        }
    }

    public static class DisplayEntry
    extends JToggleButton {
        private static final long serialVersionUID = 997196787831598016L;
        private static final Insets insets = new Insets(0, 0, 0, 0);

        public DisplayEntry(int n, int n2) {
            this.setFont((Font)UIManager.get(String.valueOf(this.getClass().getName()) + ".font"));
            this.setMargin(insets);
            if (n == n2) {
                this.setBackground(Color.LIGHT_GRAY);
            } else {
                this.setBackground(Color.WHITE);
            }
        }

        public void updateUI() {
            super.updateUI();
            this.setFont((Font)UIManager.get(String.valueOf(this.getClass().getName()) + ".font"));
        }

        public void setValue(int n) {
            this.setText(n == 0 ? "" : Integer.toString(n));
            if (n == 0) {
                this.setToolTipText(null);
            } else {
                this.setToolTipText(Integer.toString(n));
            }
        }
    }
}

