/*
 * Decompiled with CFR 0.152.
 */
package babase.ranker.ranking;

import babase.ranker.ranking.RankingChangeEvent;
import babase.ranker.ranking.RankingChangedListener;
import java.util.ArrayList;

public class Ranking {
    protected int[] _ranks;
    protected ArrayList<RankingChangedListener> _changedListeners;

    public Ranking(int n) {
        this._ranks = new int[n];
        int n2 = 0;
        while (n2 < n) {
            this._ranks[n2] = n2;
            ++n2;
        }
        this._changedListeners = new ArrayList();
    }

    public Ranking(int[] nArray) {
        this(nArray.length);
        boolean[] blArray = new boolean[nArray.length];
        int n = 0;
        while (n < blArray.length) {
            blArray[n] = false;
            ++n;
        }
        n = 0;
        while (n < nArray.length) {
            this._ranks[n] = nArray[n];
            assert (!blArray[this._ranks[n]]);
            blArray[this._ranks[n]] = true;
            ++n;
        }
    }

    public void addChangedListener(RankingChangedListener rankingChangedListener) {
        this._changedListeners.add(rankingChangedListener);
    }

    public void removeChangedListener(RankingChangedListener rankingChangedListener) {
        this._changedListeners.remove(rankingChangedListener);
    }

    public int size() {
        return this._ranks.length;
    }

    public int get(int n) {
        return this._ranks[n];
    }

    public int[] get() {
        return (int[])this._ranks.clone();
    }

    public void swap(int n, int n2, Object object) {
        if (n == n2) {
            return;
        }
        int n3 = this._ranks[n];
        this._ranks[n] = this._ranks[n2];
        this._ranks[n2] = n3;
        RankingChangedListener[] rankingChangedListenerArray = this._changedListeners.toArray(new RankingChangedListener[this._changedListeners.size()]);
        int n4 = rankingChangedListenerArray.length;
        int n5 = 0;
        while (n5 < n4) {
            RankingChangedListener rankingChangedListener = rankingChangedListenerArray[n5];
            rankingChangedListener.rankingChanged(new RankingChangeEvent.Swap(object, this, n, n2));
            ++n5;
        }
    }

    public void slide(int n, int n2, Object object) {
        int n3;
        if (n == n2) {
            return;
        }
        int n4 = this._ranks[n];
        if (n > n2) {
            n3 = n;
            while (n3 > n2) {
                this._ranks[n3] = this._ranks[n3 - 1];
                --n3;
            }
        } else {
            n3 = n;
            while (n3 < n2) {
                this._ranks[n3] = this._ranks[n3 + 1];
                ++n3;
            }
        }
        this._ranks[n2] = n4;
        RankingChangedListener[] rankingChangedListenerArray = this._changedListeners.toArray(new RankingChangedListener[this._changedListeners.size()]);
        int n5 = rankingChangedListenerArray.length;
        int n6 = 0;
        while (n6 < n5) {
            RankingChangedListener rankingChangedListener = rankingChangedListenerArray[n6];
            rankingChangedListener.rankingChanged(new RankingChangeEvent.Slide(object, this, n, n2));
            ++n6;
        }
    }

    public void permute(int[] nArray, Object object) {
        int[] nArray2 = (int[])this._ranks.clone();
        int n = 0;
        while (n < this._ranks.length) {
            this._ranks[n] = nArray[n];
            ++n;
        }
        RankingChangedListener[] rankingChangedListenerArray = this._changedListeners.toArray(new RankingChangedListener[this._changedListeners.size()]);
        int n2 = rankingChangedListenerArray.length;
        int n3 = 0;
        while (n3 < n2) {
            RankingChangedListener rankingChangedListener = rankingChangedListenerArray[n3];
            rankingChangedListener.rankingChanged(new RankingChangeEvent.Permute(object, this, nArray2, nArray));
            ++n3;
        }
    }
}

