/*
 * Decompiled with CFR 0.152.
 */
package babase.ranker;

import babase.db.Babase;
import babase.db.Group;
import babase.db.RankType;
import babase.db.RankingIdentifier;
import babase.db.RankingInfo;
import babase.ranker.Cage;
import babase.ranker.IncorporatorUI;
import babase.ranker.MainUI;
import babase.ranker.Utils;
import com.toedter.calendar.JDateChooser;
import info.clearthought.layout.TableLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.sql.SQLException;
import java.util.Date;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;

public class LoadUI {
    private final MainUI _mainUI;
    private final Babase _db;
    private final Cage _cage;
    private int[] _newRanks = null;

    public LoadUI(MainUI mainUI, Babase babase, Cage cage) {
        this._mainUI = mainUI;
        this._db = babase;
        this._cage = cage;
    }

    public int[] getNewRanks() {
        return this._newRanks;
    }

    public void start(ActionListener actionListener) {
        final JDialog jDialog = new JDialog(this._mainUI, "Load/incorporate ranking from Babase", true);
        Date date = null;
        RankType[] rankTypeArray = null;
        Group[] groupArray = null;
        try {
            date = this._db.getLatestRankingDateSaved(this._cage.rankingId);
            rankTypeArray = this._db.getRankTypes();
            groupArray = this._db.getGroups();
        }
        catch (SQLException sQLException) {
            Utils.showErrorDialog(this._mainUI, "Babase connection problem: " + sQLException.getMessage());
            return;
        }
        String string = null;
        string = date == null ? "No existing ranking for " + this._cage.rankingId + " or before." : (date.equals(this._cage.rankingId.startDate) ? "Existing ranking found for " + this._cage.rankingId + "." : "No existing ranking for " + this._cage.rankingId + ";<br>" + "closest preceding one found on" + Babase.dateToString(date) + ".");
        JLabel jLabel = new JLabel("<html>" + string + "<br>Specify the ranking to load:</html>");
        final JComboBox<RankType> jComboBox = new JComboBox<RankType>(rankTypeArray);
        jComboBox.setSelectedIndex(RankType.findRankType(rankTypeArray, this._cage.rankingId.rankType));
        final JComboBox<Group> jComboBox2 = new JComboBox<Group>(groupArray);
        jComboBox2.setSelectedIndex(Group.findGroup(groupArray, this._cage.rankingId.group));
        final JDateChooser jDateChooser = new JDateChooser("yyyy-MM-dd", "####-##-##", '_');
        jDateChooser.setDate(date == null ? this._cage.rankingId.startDate : date);
        JButton jButton = new JButton("Cancel");
        jButton.setMnemonic(67);
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                jDialog.dispose();
            }
        });
        JButton jButton2 = new JButton("Load");
        jButton2.setMnemonic(76);
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RankingIdentifier rankingIdentifier = new RankingIdentifier((Group)jComboBox2.getSelectedItem(), (RankType)jComboBox.getSelectedItem(), jDateChooser.getDate());
                jDialog.dispose();
                RankingInfo rankingInfo = null;
                try {
                    rankingInfo = LoadUI.this._db.getRankingInfo(rankingIdentifier);
                }
                catch (SQLException sQLException) {
                    Utils.showErrorDialog(LoadUI.this._mainUI, "Babase connection problem: " + sQLException.getMessage());
                    return;
                }
                if (rankingInfo == null) {
                    Utils.showErrorDialog(LoadUI.this._mainUI, "No existing ranking for " + rankingIdentifier + ".");
                    return;
                }
                IncorporatorUI.incorporate(LoadUI.this._mainUI, "Confirm changes to your ranking", LoadUI.this._cage, rankingInfo, false);
            }
        });
        double d = 10.0;
        double[] dArray = new double[]{d, -2.0, d, -2.0, d};
        double[] dArray2 = new double[]{d, -2.0, d, -2.0, d, -2.0, d, -2.0, d, -2.0, d};
        Container container = jDialog.getContentPane();
        container.setLayout((LayoutManager)new TableLayout(dArray, dArray2));
        container.add((Component)jLabel, "1, 1, 3, 1, c, t");
        container.add((Component)new JLabel("Rank type: "), "1, 3, r, c");
        container.add(jComboBox, "3, 3, f, c");
        container.add((Component)new JLabel("Group: "), "1, 5, r, c");
        container.add(jComboBox2, "3, 5, f, c");
        container.add((Component)new JLabel("Ranking start date: "), "1, 7, r, c");
        container.add((Component)jDateChooser, "3, 7, f, c");
        container.add((Component)jButton, "1, 9, c, c");
        container.add((Component)jButton2, "3, 9, c, c");
        jDialog.setDefaultCloseOperation(0);
        jDialog.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                jDialog.dispose();
            }
        });
        jDialog.pack();
        jDialog.setLocationRelativeTo(null);
        jDialog.setVisible(true);
    }
}

