/*
 * Decompiled with CFR 0.152.
 */
package babase.ranker.ranking;

import babase.ranker.ranking.Ranking;

public abstract class RankingChangeEvent {
    public final Object source;
    public final Ranking ranks;

    public RankingChangeEvent(Object object, Ranking ranking) {
        this.source = object;
        this.ranks = ranking;
    }

    public static class Permute
    extends RankingChangeEvent {
        public final int[] before;
        public final int[] after;

        public Permute(Object object, Ranking ranking, int[] nArray, int[] nArray2) {
            super(object, ranking);
            this.before = nArray;
            this.after = nArray2;
        }

        public String toString() {
            String string = "PERMUTE([";
            int n = 0;
            while (n < this.before.length) {
                if (n > 0) {
                    string = String.valueOf(string) + ", ";
                }
                string = String.valueOf(string) + (this.before[n] + 1);
                ++n;
            }
            string = String.valueOf(string) + "] -> [";
            n = 0;
            while (n < this.after.length) {
                if (n > 0) {
                    string = String.valueOf(string) + ", ";
                }
                string = String.valueOf(string) + (this.after[n] + 1);
                ++n;
            }
            string = String.valueOf(string) + ']';
            return string;
        }
    }

    public static class Slide
    extends RankingChangeEvent {
        public final int from;
        public final int to;

        public Slide(Object object, Ranking ranking, int n, int n2) {
            super(object, ranking);
            this.from = n;
            this.to = n2;
        }

        public String toString() {
            return "SLIDE(" + (this.from + 1) + "->" + (this.to + 1) + ")";
        }
    }

    public static class Swap
    extends RankingChangeEvent {
        public final int i;
        public final int j;

        public Swap(Object object, Ranking ranking, int n, int n2) {
            super(object, ranking);
            this.i = n;
            this.j = n2;
        }

        public String toString() {
            return "SWAP(" + (this.i + 1) + ", " + (this.j + 1) + ")";
        }
    }
}

