/*
 * Decompiled with CFR 0.152.
 */
package babase.ranker.auto;

import babase.db.Individual;
import babase.ranker.Cage;
import babase.ranker.IndividualHeader;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.EnumMap;

public class DefaultAutoRanker {
    private static final EnumMap<Individual.IndividualClassification, Integer> INDIVIDUAL_CLASSIFICATION_ORDER = new EnumMap(Individual.IndividualClassification.class);

    static {
        INDIVIDUAL_CLASSIFICATION_ORDER.put(Individual.IndividualClassification.ADULT_MALE, 0);
        INDIVIDUAL_CLASSIFICATION_ORDER.put(Individual.IndividualClassification.SUBADULT_MALE, 1);
        INDIVIDUAL_CLASSIFICATION_ORDER.put(Individual.IndividualClassification.ADULT_FEMALE, 2);
        INDIVIDUAL_CLASSIFICATION_ORDER.put(Individual.IndividualClassification.JUV_MALE, 3);
        INDIVIDUAL_CLASSIFICATION_ORDER.put(Individual.IndividualClassification.JUV_FEMALE, 4);
        INDIVIDUAL_CLASSIFICATION_ORDER.put(Individual.IndividualClassification.UNKNOWN, 5);
    }

    public static int[] rank(final Cage cage) {
        Integer[] integerArray = new Integer[cage.ranks.size()];
        int n = 0;
        while (n < cage.ranks.size()) {
            integerArray[n] = cage.ranks.get(n);
            ++n;
        }
        Arrays.sort(integerArray, new Comparator<Integer>(){

            @Override
            public int compare(Integer n, Integer n2) {
                Individual.IndividualClassification individualClassification;
                IndividualHeader individualHeader;
                IndividualHeader individualHeader2 = cage.individuals[n];
                if (individualHeader2 == (individualHeader = cage.individuals[n2])) {
                    return 0;
                }
                Date date = cage.rankingId.startDate;
                Individual.IndividualClassification individualClassification2 = individualHeader2.getClassification(date);
                if (individualClassification2 == (individualClassification = individualHeader.getClassification(date))) {
                    if (individualClassification2 == Individual.IndividualClassification.ADULT_MALE) {
                        if (individualHeader2.birth.before(individualHeader.birth)) {
                            return 1;
                        }
                        if (individualHeader2.birth.after(individualHeader.birth)) {
                            return -1;
                        }
                        return individualHeader2.sname.compareTo(individualHeader.sname);
                    }
                    if (individualClassification2 == Individual.IndividualClassification.ADULT_FEMALE) {
                        return individualHeader2.sname.compareTo(individualHeader.sname);
                    }
                    if (individualHeader2.birth.before(individualHeader.birth)) {
                        return -1;
                    }
                    if (individualHeader2.birth.after(individualHeader.birth)) {
                        return 1;
                    }
                    return individualHeader2.sname.compareTo(individualHeader.sname);
                }
                return ((Integer)INDIVIDUAL_CLASSIFICATION_ORDER.get((Object)individualClassification2)).compareTo((Integer)INDIVIDUAL_CLASSIFICATION_ORDER.get((Object)individualClassification));
            }
        });
        int[] nArray = new int[integerArray.length];
        int n2 = 0;
        while (n2 < integerArray.length) {
            nArray[n2] = integerArray[n2];
            ++n2;
        }
        return nArray;
    }
}

