/*
 * Decompiled with CFR 0.152.
 */
package babase.db;

import babase.db.Babase;
import java.math.BigDecimal;
import java.util.Date;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Individual {
    public final String sname;
    public final Integer bioId;
    public final String name;
    public final String pid;
    public final Date birth;
    public final Integer bStatus;
    public final Character sex;
    public final BigDecimal matGrp;
    public final Date statDate;
    public final Integer status;
    public final Integer dCause;
    public final Integer dCauseConfidence;
    public final Date matured;
    public final Date ranked;

    public static int findIndividualBySname(String string, Individual[] individualArray) {
        int n = 0;
        while (n < individualArray.length) {
            if (string.equals(individualArray[n].sname)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public Individual(String string, Integer n, String string2, String string3, Date date, Integer n2, Character c, BigDecimal bigDecimal, Date date2, Integer n3, Integer n4, Integer n5, Date date3, Date date4) {
        assert (string != null && n != null && string2 != null && date != null);
        this.sname = string;
        this.bioId = n;
        this.name = string2;
        this.pid = string3;
        this.birth = date;
        this.bStatus = n2;
        this.sex = c;
        this.matGrp = bigDecimal;
        this.statDate = date2;
        this.status = n3;
        this.dCause = n4;
        this.dCauseConfidence = n5;
        this.matured = date3;
        this.ranked = date4;
    }

    public Individual(Individual individual) {
        this.sname = individual.sname;
        this.bioId = individual.bioId;
        this.name = individual.name;
        this.pid = individual.pid;
        this.birth = individual.birth;
        this.bStatus = individual.bStatus;
        this.sex = individual.sex;
        this.matGrp = individual.matGrp;
        this.statDate = individual.statDate;
        this.status = individual.status;
        this.dCause = individual.dCause;
        this.dCauseConfidence = individual.dCauseConfidence;
        this.matured = individual.matured;
        this.ranked = individual.ranked;
    }

    public IndividualClassification getClassification(Date date) {
        if (this.sex != null && this.sex.charValue() == 'F') {
            if (this.matured != null && !date.before(this.matured)) {
                return IndividualClassification.ADULT_FEMALE;
            }
            return IndividualClassification.JUV_FEMALE;
        }
        if (this.sex != null && this.sex.charValue() == 'M') {
            if (this.ranked != null && !date.before(this.ranked)) {
                return IndividualClassification.ADULT_MALE;
            }
            if (this.matured != null && !date.before(this.matured)) {
                return IndividualClassification.SUBADULT_MALE;
            }
            return IndividualClassification.JUV_MALE;
        }
        return IndividualClassification.UNKNOWN;
    }

    public Element toXML(Document document) {
        Element element = document.createElement("individual");
        element.setAttribute("sname", this.sname);
        element.setAttribute("bioId", this.bioId.toString());
        element.setAttribute("name", this.name);
        if (this.pid != null) {
            element.setAttribute("pid", this.pid);
        }
        element.setAttribute("birth", Babase.dateToXMLString(this.birth));
        if (this.bStatus != null) {
            element.setAttribute("bStatus", this.bStatus.toString());
        }
        if (this.sex != null) {
            element.setAttribute("sex", this.sex.toString());
        }
        if (this.matGrp != null) {
            element.setAttribute("matGrp", this.matGrp.toString());
        }
        if (this.statDate != null) {
            element.setAttribute("statDate", Babase.dateToXMLString(this.statDate));
        }
        if (this.status != null) {
            element.setAttribute("status", this.status.toString());
        }
        if (this.dCause != null) {
            element.setAttribute("dCause", this.dCause.toString());
        }
        if (this.dCauseConfidence != null) {
            element.setAttribute("dCauseConfidence", this.dCauseConfidence.toString());
        }
        if (this.matured != null) {
            element.setAttribute("matured", Babase.dateToXMLString(this.matured));
        }
        if (this.ranked != null) {
            element.setAttribute("ranked", Babase.dateToXMLString(this.ranked));
        }
        return element;
    }

    public static Individual fromXML(Element element) throws Babase.LoadFromXMLException {
        assert (element.getNodeName().equals("individual"));
        return new Individual(element.getAttribute("sname"), new Integer(element.getAttribute("bioId")), element.getAttribute("name"), element.hasAttribute("pid") ? element.getAttribute("pid") : null, Babase.xmlStringToDate(element.getAttribute("birth")), element.hasAttribute("bStatus") ? new Integer(element.getAttribute("bStatus")) : null, element.hasAttribute("sex") ? new Character(element.getAttribute("sex").charAt(0)) : null, element.hasAttribute("matGrp") ? new BigDecimal(element.getAttribute("matGrp")) : null, element.hasAttribute("statDate") ? Babase.xmlStringToDate(element.getAttribute("statDate")) : null, element.hasAttribute("status") ? new Integer(element.getAttribute("status")) : null, element.hasAttribute("dCause") ? new Integer(element.getAttribute("dCause")) : null, element.hasAttribute("dCauseConfidence") ? new Integer(element.getAttribute("dCauseConfidence")) : null, element.hasAttribute("matured") ? Babase.xmlStringToDate(element.getAttribute("matured")) : null, element.hasAttribute("ranked") ? Babase.xmlStringToDate(element.getAttribute("ranked")) : null);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum IndividualClassification {
        ADULT_FEMALE,
        JUV_FEMALE,
        ADULT_MALE,
        SUBADULT_MALE,
        JUV_MALE,
        UNKNOWN;

    }
}

