/*
 * Decompiled with CFR 0.152.
 */
package babase.ranker;

import babase.db.Babase;
import babase.db.Individual;
import babase.db.InteractionSpec;
import babase.db.RankingIdentifier;
import babase.ranker.IndividualHeader;
import babase.ranker.ranking.Ranking;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Calendar;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class Cage {
    private static DocumentBuilderFactory _factory = DocumentBuilderFactory.newInstance();
    public final RankingIdentifier rankingId;
    public final InteractionSpec interactionSpec;
    public final IndividualHeader[] individuals;
    public final Ranking ranks;
    public final int[][] matrix;

    public Cage(RankingIdentifier rankingIdentifier, InteractionSpec interactionSpec, Individual[] individualArray, int[] nArray, int[][] nArray2) {
        this.rankingId = rankingIdentifier;
        this.interactionSpec = interactionSpec;
        this.individuals = new IndividualHeader[individualArray.length];
        int n = 0;
        while (n < individualArray.length) {
            this.individuals[n] = new IndividualHeader(individualArray[n]);
            ++n;
        }
        this.ranks = nArray == null ? new Ranking(individualArray.length) : new Ranking(nArray);
        this.matrix = (int[][])nArray2.clone();
        n = 0;
        while (n < nArray2.length) {
            this.matrix[n] = (int[])nArray2[n].clone();
            ++n;
        }
    }

    public Cage(RankingIdentifier rankingIdentifier, InteractionSpec interactionSpec, Individual[] individualArray, int[][] nArray) {
        this(rankingIdentifier, interactionSpec, individualArray, null, nArray);
    }

    private void printRepeat(PrintStream printStream, int n, String string) {
        int n2 = 0;
        while (n2 < n) {
            printStream.print(string);
            ++n2;
        }
    }

    public void print(PrintStream printStream) {
        int n;
        int n2;
        int n3;
        printStream.println(this.rankingId);
        printStream.println(this.interactionSpec);
        printStream.println("Printed on " + Babase.datetimeToString(Calendar.getInstance().getTime()));
        printStream.println();
        int n4 = 0;
        int n5 = 0;
        while (n5 < this.individuals.length) {
            n3 = this.individuals[n5].sname.length();
            if (n4 < n3) {
                n4 = n3;
            }
            ++n5;
        }
        n3 = n5 = Integer.toString(this.ranks.size() + 1).length();
        int n6 = 0;
        while (n6 < this.matrix.length) {
            n2 = 0;
            while (n2 < this.matrix[n6].length) {
                n = Integer.toString(this.matrix[n6][n2]).length();
                if (n3 < n) {
                    n3 = n;
                }
                ++n2;
            }
            ++n6;
        }
        ++n3;
        n6 = 0;
        while (n6 < n4) {
            this.printRepeat(printStream, n4 + 1 + n5 + 1, " ");
            n2 = 0;
            while (n2 < this.individuals.length) {
                String string = this.individuals[this.ranks.get((int)n2)].sname;
                if (string.length() > n6) {
                    printStream.format("%1$" + n3 + "s", "" + string.charAt(n6));
                } else {
                    this.printRepeat(printStream, n3, " ");
                }
                ++n2;
            }
            printStream.println();
            ++n6;
        }
        this.printRepeat(printStream, n4 + 1 + n5 + 1, " ");
        n6 = 0;
        while (n6 < this.individuals.length) {
            printStream.format("%1$" + n3 + "d", n6 + 1);
            ++n6;
        }
        printStream.println();
        this.printRepeat(printStream, n4 + 1 + n5 + 1, " ");
        this.printRepeat(printStream, this.individuals.length * n3, "_");
        printStream.println();
        n6 = 0;
        while (n6 < this.individuals.length) {
            String string = this.individuals[this.ranks.get((int)n6)].sname;
            printStream.format("%1$" + n4 + "s %2$" + n5 + "d|", string, n6 + 1);
            n = 0;
            while (n < this.individuals.length) {
                int n7 = this.matrix[this.ranks.get(n6)][this.ranks.get(n)];
                if (n6 == n) {
                    this.printRepeat(printStream, n3 - 1, " ");
                    printStream.print("X");
                } else if (n7 != 0) {
                    printStream.format("%1$" + n3 + "d", n7);
                } else {
                    this.printRepeat(printStream, n3 - 1, " ");
                    printStream.print(".");
                }
                ++n;
            }
            printStream.println();
            ++n6;
        }
        printStream.println();
    }

    public void dumpToXML(File file) throws Babase.DumpToXMLException {
        try {
            DocumentBuilder documentBuilder = _factory.newDocumentBuilder();
            Document document = documentBuilder.newDocument();
            Element element = document.createElement("ranking");
            document.appendChild(element);
            element.appendChild(this.rankingId.toXML(document));
            element.appendChild(this.interactionSpec.toXML(document));
            Element element2 = document.createElement("individuals");
            element2.setAttribute("n", String.valueOf(this.individuals.length));
            element.appendChild(element2);
            int n = 0;
            while (n < this.individuals.length) {
                element2.appendChild(this.individuals[n].toXML(document));
                ++n;
            }
            Element element3 = document.createElement("ranks");
            element3.setAttribute("n", String.valueOf(this.ranks.size()));
            element.appendChild(element3);
            int n2 = 0;
            while (n2 < this.ranks.size()) {
                Element element4 = document.createElement("rank");
                element4.setAttribute("i", String.valueOf(this.ranks.get(n2)));
                element3.appendChild(element4);
                ++n2;
            }
            Element element5 = document.createElement("matrix");
            element5.setAttribute("n", String.valueOf(this.individuals.length));
            element.appendChild(element5);
            int n3 = 0;
            while (n3 < this.individuals.length) {
                int n4 = 0;
                while (n4 < this.individuals.length) {
                    if (this.matrix[n3][n4] != 0) {
                        Element element6 = document.createElement("entry");
                        element6.setAttribute("i", String.valueOf(n3));
                        element6.setAttribute("j", String.valueOf(n4));
                        element6.setAttribute("v", String.valueOf(this.matrix[n3][n4]));
                        element5.appendChild(element6);
                    }
                    ++n4;
                }
                ++n3;
            }
            TransformerFactory.newInstance().newTransformer().transform(new DOMSource(document), new StreamResult(file));
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new Babase.DumpToXMLException("XML parser configuration error", parserConfigurationException);
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            throw new Babase.DumpToXMLException("XML transformer configuration error", transformerConfigurationException);
        }
        catch (TransformerException transformerException) {
            throw new Babase.DumpToXMLException("XML transformer error", transformerException);
        }
        catch (TransformerFactoryConfigurationError transformerFactoryConfigurationError) {
            throw new Babase.DumpToXMLException("XML transformer factory configuration error", transformerFactoryConfigurationError);
        }
    }

    public static Cage loadFromXML(File file) throws Babase.LoadFromXMLException {
        try {
            DocumentBuilder documentBuilder = _factory.newDocumentBuilder();
            Document document = documentBuilder.parse(file);
            Element element = document.getDocumentElement();
            RankingIdentifier rankingIdentifier = null;
            InteractionSpec interactionSpec = null;
            Individual[] individualArray = null;
            int[] nArray = null;
            int[][] nArray2 = null;
            Node node = element.getFirstChild();
            while (node != null) {
                if (node.getNodeType() == 1) {
                    int n;
                    Element element2 = (Element)node;
                    if (element2.getNodeName().equals("rankingId")) {
                        rankingIdentifier = RankingIdentifier.fromXML(element2);
                    } else if (element2.getNodeName().equals("interactionSpec")) {
                        interactionSpec = InteractionSpec.fromXML(element2);
                    } else if (element2.getNodeName().equals("individuals")) {
                        n = Integer.parseInt(element2.getAttribute("n"));
                        individualArray = new Individual[n];
                        int n2 = 0;
                        Element element3 = (Element)element2.getFirstChild();
                        while (element3 != null) {
                            if (n2 > n) {
                                throw new Babase.LoadFromXMLException("element <individuals> contains too many <individual> subelements");
                            }
                            individualArray[n2] = Individual.fromXML(element3);
                            ++n2;
                            element3 = (Element)element3.getNextSibling();
                        }
                        if (n2 < n) {
                            throw new Babase.LoadFromXMLException("element <individuals> contains too few <individual> subelements");
                        }
                    } else if (element2.getNodeName().equals("ranks")) {
                        n = Integer.parseInt(element2.getAttribute("n"));
                        nArray = new int[n];
                        int n3 = 0;
                        Element element4 = (Element)element2.getFirstChild();
                        while (element4 != null) {
                            if (n3 > n) {
                                throw new Babase.LoadFromXMLException("element <ranks> contains too many <rank> subelements");
                            }
                            nArray[n3] = Integer.parseInt(element4.getAttribute("i"));
                            ++n3;
                            element4 = (Element)element4.getNextSibling();
                        }
                        if (n3 < n) {
                            throw new Babase.LoadFromXMLException("element <ranks> contains too few <rank> subelements");
                        }
                    } else if (element2.getNodeName().equals("matrix")) {
                        n = Integer.parseInt(element2.getAttribute("n"));
                        nArray2 = new int[n][n];
                        int n4 = 0;
                        while (n4 < n) {
                            int n5 = 0;
                            while (n5 < n) {
                                nArray2[n4][n5] = 0;
                                ++n5;
                            }
                            ++n4;
                        }
                        Element element5 = (Element)element2.getFirstChild();
                        while (element5 != null) {
                            int n6 = Integer.parseInt(element5.getAttribute("i"));
                            int n7 = Integer.parseInt(element5.getAttribute("j"));
                            int n8 = Integer.parseInt(element5.getAttribute("v"));
                            if (n6 < 0 || n6 >= n) {
                                throw new Babase.LoadFromXMLException("index i of element <entry i='" + n6 + "' .../> is out of bounds");
                            }
                            if (n7 < 0 || n7 >= n) {
                                throw new Babase.LoadFromXMLException("index j of element <entry ... j='" + n7 + "' .../> is out of bounds");
                            }
                            if (n8 <= 0) {
                                throw new Babase.LoadFromXMLException("value v of element <entry ... v='" + n8 + "/> element is not positive");
                            }
                            nArray2[n6][n7] = n8;
                            element5 = (Element)element5.getNextSibling();
                        }
                    }
                }
                node = node.getNextSibling();
            }
            return new Cage(rankingIdentifier, interactionSpec, individualArray, nArray, nArray2);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new Babase.LoadFromXMLException("XML parser configuration error", parserConfigurationException);
        }
        catch (SAXException sAXException) {
            throw new Babase.LoadFromXMLException("XML parsing error", sAXException);
        }
        catch (IOException iOException) {
            throw new Babase.LoadFromXMLException("error reading file " + file, iOException);
        }
    }
}

