/*
 * Decompiled with CFR 0.152.
 */
package babase.ranker;

import babase.db.Babase;
import babase.ranker.AboutUI;
import babase.ranker.Cage;
import babase.ranker.ChooserUI;
import babase.ranker.InteractionMatrixDisplay;
import babase.ranker.LoginUI;
import babase.ranker.MainUI;
import babase.ranker.SlidableHeader;
import babase.ranker.SwappableHeader;
import babase.ranker.Utils;
import babase.ranker.WelcomeUI;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.sql.SQLException;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.filechooser.FileFilter;
import javax.swing.plaf.FontUIResource;

public class Main
extends WindowAdapter
implements ActionListener {
    public static final Class[] CLASSES_WITH_CHANGABLE_FONT_SIZES = new Class[]{InteractionMatrixDisplay.DisplayEntry.class, SlidableHeader.SlidableHeaderCell.class, SwappableHeader.SwappableHeaderCell.class, MainUI.RankLabel.class};
    private final Main _this = this;
    private final Babase _db;
    private final WelcomeUI _welcomeUI;
    private final LoginUI _loginUI;
    private final AboutUI _aboutUI;
    private ChooserUI _chooserUI = null;
    private MainUI _mainUI = null;
    private final JFileChooser _textFileChooser;
    private final JFileChooser _xmlFileChooser;

    public static void main(String[] stringArray) throws Exception {
        SwingUtilities.invokeAndWait(new Runnable(){

            public void run() {
                try {
                    new Main();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        });
    }

    public Main() throws ClassNotFoundException, InterruptedException, InvocationTargetException, InstantiationException, IllegalAccessException, UnsupportedLookAndFeelException {
        UIManager.setLookAndFeel("javax.swing.plaf.metal.MetalLookAndFeel");
        FontUIResource[] fontUIResourceArray = new FontUIResource[]{new FontUIResource("", 0, 10), new FontUIResource("", 0, 12), new FontUIResource("", 0, 12), new FontUIResource("", 0, 9)};
        int n = 0;
        while (n < CLASSES_WITH_CHANGABLE_FONT_SIZES.length) {
            UIManager.put(String.valueOf(CLASSES_WITH_CHANGABLE_FONT_SIZES[n].getName()) + ".font.default", fontUIResourceArray[n]);
            UIManager.put(String.valueOf(CLASSES_WITH_CHANGABLE_FONT_SIZES[n].getName()) + ".font", fontUIResourceArray[n]);
            ++n;
        }
        this._db = new Babase();
        this._welcomeUI = new WelcomeUI(this, this);
        this._loginUI = new LoginUI(this._db);
        this._aboutUI = new AboutUI();
        this._textFileChooser = new JFileChooser();
        this._textFileChooser.setDialogTitle("Select a .txt file");
        this._textFileChooser.addChoosableFileFilter(new FileFilter(){

            public boolean accept(File file) {
                if (file.isDirectory()) {
                    return true;
                }
                String string = file.getName();
                int n = string.lastIndexOf(46);
                if (n > 0 && n < string.length() - 1) {
                    return string.substring(n + 1).toLowerCase().equals("txt");
                }
                return false;
            }

            public String getDescription() {
                return "Babase Ranker State Print-Out (.txt)";
            }
        });
        this._xmlFileChooser = new JFileChooser();
        this._xmlFileChooser.setDialogTitle("Select a .xml file");
        this._xmlFileChooser.addChoosableFileFilter(new FileFilter(){

            public boolean accept(File file) {
                if (file.isDirectory()) {
                    return true;
                }
                String string = file.getName();
                int n = string.lastIndexOf(46);
                if (n > 0 && n < string.length() - 1) {
                    return string.substring(n + 1).toLowerCase().equals("xml");
                }
                return false;
            }

            public String getDescription() {
                return "Babase Ranker State Dump File (.xml)";
            }
        });
        this._welcomeUI.setVisible(true);
    }

    public void exit() {
        System.exit(0);
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.exit();
    }

    private void newChooserUI() {
        try {
            this._chooserUI = new ChooserUI(this._db, this._this, this._this);
        }
        catch (SQLException sQLException) {
            this._chooserUI = null;
            this._welcomeUI.setVisible(true);
            JOptionPane.showMessageDialog(this._welcomeUI, String.valueOf(sQLException.getMessage()) + "\n");
        }
        this._chooserUI.setVisible(true);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if ("welcome.create".equals(actionEvent.getActionCommand())) {
            this._welcomeUI.setVisible(false);
            if (!this._db.isConnected()) {
                this._loginUI.start(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        Main.this.newChooserUI();
                    }
                }, new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        Main.this._welcomeUI.setVisible(true);
                    }
                });
            } else {
                this.newChooserUI();
            }
        } else if ("welcome.restore".equals(actionEvent.getActionCommand())) {
            if (this._xmlFileChooser.showOpenDialog(this._welcomeUI) == 0) {
                Cage cage = null;
                try {
                    cage = Cage.loadFromXML(this._xmlFileChooser.getSelectedFile());
                }
                catch (Exception exception) {
                    Utils.showErrorDialog(this._xmlFileChooser, "Error restoring from file!");
                }
                if (cage != null) {
                    this._welcomeUI.setVisible(false);
                    this._mainUI = new MainUI(this, this, this._db, cage, this._textFileChooser, this._xmlFileChooser, this._loginUI);
                    this._mainUI.ranksSaved();
                    this._mainUI.setVisible(true);
                }
            }
        } else if ("chooser.rank".equals(actionEvent.getActionCommand())) {
            Cage cage = this._chooserUI.createCage(this._db);
            if (cage != null) {
                this._chooserUI.setVisible(false);
                this._mainUI = new MainUI(this, this, this._db, cage, this._textFileChooser, this._xmlFileChooser, this._loginUI);
                this._mainUI.setVisible(true);
            }
        } else if ("chooser.cancel".equals(actionEvent.getActionCommand())) {
            this._chooserUI.setVisible(false);
            this._welcomeUI.setVisible(true);
        } else if ("main.close".equals(actionEvent.getActionCommand())) {
            this._mainUI.dispose();
            this._mainUI = null;
            this._welcomeUI.setVisible(true);
        } else if ("about".equals(actionEvent.getActionCommand())) {
            this._aboutUI.setVisible(true);
        } else if ("exit".equals(actionEvent.getActionCommand())) {
            this.exit();
        }
    }
}

