/*
 * Decompiled with CFR 0.152.
 */
package babase.ranker;

import babase.db.Individual;
import babase.ranker.InteractionMatrixDisplay;
import babase.ranker.ranking.Ranking;
import babase.ranker.ranking.RankingChangeEvent;
import babase.ranker.ranking.RankingChangedListener;
import info.clearthought.layout.TableLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.PrintStream;
import java.util.ArrayList;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class StatsPanel
extends JPanel
implements RankingChangedListener,
ActionListener {
    private static final long serialVersionUID = 1330200575513632020L;
    protected final InteractionMatrixDisplay _interactionMatrixDisplay;
    protected final Ranking _ranks;
    protected final int[][] _matrix;
    protected final Individual[] _individuals;
    protected Stats _stats;
    protected boolean _statsUpToDate;
    protected final String[] _componentNames = new String[]{"# pairs rev.:", "# pairs significantly rev.:", "Max. rev. magnitude:", "Pairs with max. rev. magnitude:", "Max. rev. distance:", "Pairs with max. rev. distance:"};
    protected final String[] _componentDescriptions = new String[]{"<html><b>Number of reversed pairs</b>:<br>i.e., number of positive entries below diagonal</html>", "<html><b>Number of significantly reversed pairs</b>:<br>i.e., number of positive entries below diagonal<br>with at least 2 interactions</html>", "<html><b>Maximum reversal magnitude</b>:<br>i.e., the maximum value among positive entries below diagonal,<br>or 0 if there are no positive entries below diagonal</html>", "<html><b>Pairs with the maximum reversal magnitude</b>:<br>select the pair to highlight the corresponding matrix entry</html>", "<html><b>Maximum reversal distance in ranks</b>:<br>i.e., the maximum difference between actor/actee ranks<br>among posititve entries below diagonal,<br>or 0 if there are no positive entries below diagonal</html>", "<html><b>Pairs with the maximum reversal distance</b>:<br>select the pair to highlight the corresponding matrix entry</html>"};
    protected final Component[] _components;
    protected final JLabel _numPairsReversed;
    protected final JLabel _numPairsSignificantlyReversed;
    protected final JLabel _maxReversalMagnitude;
    protected final JComboBox _pairsWithMaxReversalMagnitude;
    protected final JLabel _maxReversalDistance;
    protected final JComboBox _pairsWithMaxReversalDistance;

    public StatsPanel(InteractionMatrixDisplay interactionMatrixDisplay, Ranking ranking, Individual[] individualArray, int[][] nArray) {
        this._interactionMatrixDisplay = interactionMatrixDisplay;
        this._ranks = ranking;
        this._matrix = nArray;
        this._individuals = individualArray;
        this._stats = new Stats(ranking, nArray);
        this._statsUpToDate = false;
        this._numPairsReversed = new JLabel();
        this._numPairsReversed.setHorizontalAlignment(2);
        this._numPairsSignificantlyReversed = new JLabel();
        this._numPairsSignificantlyReversed.setHorizontalAlignment(2);
        this._maxReversalMagnitude = new JLabel();
        this._maxReversalMagnitude.setHorizontalAlignment(2);
        this._pairsWithMaxReversalMagnitude = new JComboBox();
        this._maxReversalDistance = new JLabel();
        this._maxReversalDistance.setHorizontalAlignment(2);
        this._pairsWithMaxReversalDistance = new JComboBox();
        this._ranks.addChangedListener(this);
        double d = 5.0;
        double[] dArray = new double[]{d, -2.0, d, -2.0, d};
        double[] dArray2 = new double[]{d, -2.0, d, -2.0, d, -2.0, d, -2.0, d, -2.0, d, -2.0, d};
        this.setLayout((LayoutManager)new TableLayout(dArray, dArray2));
        this._components = new Component[]{this._numPairsReversed, this._numPairsSignificantlyReversed, this._maxReversalMagnitude, this._pairsWithMaxReversalMagnitude, this._maxReversalDistance, this._pairsWithMaxReversalDistance};
        int n = 0;
        while (n < this._components.length) {
            JLabel jLabel = new JLabel(this._componentNames[n]);
            jLabel.setToolTipText(this._componentDescriptions[n]);
            this.add((Component)jLabel, "1 " + (1 + n * 2) + " r c");
            this.add(this._components[n], "3 " + (1 + n * 2) + " f c");
            ++n;
        }
        this.addComponentListener(new ComponentAdapter(){

            public void componentShown(ComponentEvent componentEvent) {
                if (!StatsPanel.this._statsUpToDate) {
                    StatsPanel.this.redisplay();
                }
            }
        });
    }

    protected static Object makeObject(final String string) {
        return new Object(){

            public String toString() {
                return string;
            }
        };
    }

    protected void redisplay() {
        int n;
        int n2;
        if (!this._statsUpToDate) {
            this._stats.compute(this._ranks, this._matrix);
            this._statsUpToDate = true;
        }
        this._numPairsReversed.setText(Integer.toString(this._stats.numPairsReversed));
        this._numPairsSignificantlyReversed.setText(Integer.toString(this._stats.numPairsSignificantlyReversed));
        this._maxReversalMagnitude.setText(Integer.toString(this._stats.maxReversalMagnitude));
        this._pairsWithMaxReversalMagnitude.removeActionListener(this);
        this._pairsWithMaxReversalMagnitude.removeAllItems();
        this._pairsWithMaxReversalMagnitude.addItem(StatsPanel.makeObject(this._stats.iWithMaxReversalMagnitude.isEmpty() ? "(None)" : "(Click to Choose)"));
        int n3 = 0;
        while (n3 < this._stats.iWithMaxReversalMagnitude.size()) {
            n2 = this._stats.iWithMaxReversalMagnitude.get(n3);
            n = this._stats.jWithMaxReversalMagnitude.get(n3);
            this._pairsWithMaxReversalMagnitude.addItem(StatsPanel.makeObject(String.valueOf(this._individuals[this._ranks.get((int)n2)].sname) + " (" + (n2 + 1) + ") vs. " + this._individuals[this._ranks.get((int)n)].sname + " (" + (n + 1) + ")"));
            ++n3;
        }
        this._pairsWithMaxReversalMagnitude.addActionListener(this);
        this._maxReversalDistance.setText(Integer.toString(this._stats.maxReversalDistance));
        this._pairsWithMaxReversalDistance.removeActionListener(this);
        this._pairsWithMaxReversalDistance.removeAllItems();
        this._pairsWithMaxReversalDistance.addItem(StatsPanel.makeObject(this._stats.iWithMaxReversalDistance.isEmpty() ? "(None)" : "(Click to Choose)"));
        n3 = 0;
        while (n3 < this._stats.iWithMaxReversalDistance.size()) {
            n2 = this._stats.iWithMaxReversalDistance.get(n3);
            n = this._stats.jWithMaxReversalDistance.get(n3);
            this._pairsWithMaxReversalDistance.addItem(StatsPanel.makeObject(String.valueOf(this._individuals[this._ranks.get((int)n2)].sname) + " (" + (n2 + 1) + ") vs. " + this._individuals[this._ranks.get((int)n)].sname + " (" + (n + 1) + ")"));
            ++n3;
        }
        this._pairsWithMaxReversalDistance.addActionListener(this);
    }

    public void rankingChanged(RankingChangeEvent rankingChangeEvent) {
        this._statsUpToDate = false;
        if (this.isVisible()) {
            this.redisplay();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        JComboBox jComboBox = (JComboBox)actionEvent.getSource();
        int n = jComboBox.getSelectedIndex();
        if (n == -1 || n == 0) {
            return;
        }
        if (jComboBox == this._pairsWithMaxReversalMagnitude) {
            int n2 = this._stats.iWithMaxReversalMagnitude.get(n - 1);
            int n3 = this._stats.jWithMaxReversalMagnitude.get(n - 1);
            this._interactionMatrixDisplay.selectDisplayEntry(n2, n3);
        } else if (jComboBox == this._pairsWithMaxReversalDistance) {
            int n4 = this._stats.iWithMaxReversalDistance.get(n - 1);
            int n5 = this._stats.jWithMaxReversalDistance.get(n - 1);
            this._interactionMatrixDisplay.selectDisplayEntry(n4, n5);
        }
    }

    public void print(PrintStream printStream) {
        int n = 0;
        int n2 = 0;
        while (n2 < this._componentNames.length) {
            int n3 = this._componentNames[n2].length();
            if (n < n3) {
                n = n3;
            }
            ++n2;
        }
        n2 = 0;
        while (n2 < this._components.length) {
            printStream.format("%1$" + n + "s ", this._componentNames[n2]);
            if (this._components[n2] instanceof JLabel) {
                printStream.print(((JLabel)this._components[n2]).getText());
            } else if (this._components[n2] instanceof JComboBox) {
                JComboBox jComboBox = (JComboBox)this._components[n2];
                int n4 = 1;
                while (n4 < jComboBox.getItemCount()) {
                    if (n4 != 1) {
                        printStream.print(", ");
                    }
                    printStream.print(jComboBox.getItemAt(n4));
                    ++n4;
                }
            }
            printStream.println();
            ++n2;
        }
    }

    public static class Stats {
        protected int numPairsReversed;
        protected int numPairsSignificantlyReversed;
        protected int maxReversalMagnitude;
        protected ArrayList<Integer> iWithMaxReversalMagnitude;
        protected ArrayList<Integer> jWithMaxReversalMagnitude;
        protected int maxReversalDistance;
        protected ArrayList<Integer> iWithMaxReversalDistance;
        protected ArrayList<Integer> jWithMaxReversalDistance;

        public Stats(Ranking ranking, int[][] nArray) {
            this.compute(ranking, nArray);
        }

        public void compute(Ranking ranking, int[][] nArray) {
            int n;
            this.numPairsReversed = 0;
            this.numPairsSignificantlyReversed = 0;
            this.maxReversalMagnitude = 0;
            this.maxReversalDistance = 0;
            int n2 = 0;
            while (n2 < ranking.size()) {
                n = 0;
                while (n < n2) {
                    if (nArray[ranking.get(n2)][ranking.get(n)] > 0) {
                        ++this.numPairsReversed;
                        if (nArray[ranking.get(n2)][ranking.get(n)] > 1) {
                            ++this.numPairsSignificantlyReversed;
                        }
                        if (nArray[ranking.get(n2)][ranking.get(n)] > this.maxReversalMagnitude) {
                            this.maxReversalMagnitude = nArray[ranking.get(n2)][ranking.get(n)];
                        }
                        if (n2 - n > this.maxReversalDistance) {
                            this.maxReversalDistance = n2 - n;
                        }
                    }
                    ++n;
                }
                ++n2;
            }
            this.iWithMaxReversalMagnitude = new ArrayList();
            this.jWithMaxReversalMagnitude = new ArrayList();
            this.iWithMaxReversalDistance = new ArrayList();
            this.jWithMaxReversalDistance = new ArrayList();
            if (this.numPairsReversed > 0) {
                n2 = 0;
                while (n2 < ranking.size()) {
                    n = 0;
                    while (n < n2) {
                        if (nArray[ranking.get(n2)][ranking.get(n)] == this.maxReversalMagnitude) {
                            this.iWithMaxReversalMagnitude.add(n2);
                            this.jWithMaxReversalMagnitude.add(n);
                        }
                        if (nArray[ranking.get(n2)][ranking.get(n)] > 0 && n2 - n == this.maxReversalDistance) {
                            this.iWithMaxReversalDistance.add(n2);
                            this.jWithMaxReversalDistance.add(n);
                        }
                        ++n;
                    }
                    ++n2;
                }
            }
        }
    }
}

