/*
 * Decompiled with CFR 0.152.
 */
package babase.ranker;

import babase.ranker.Header;
import babase.ranker.Utils;
import babase.ranker.ranking.Ranking;
import babase.ranker.ranking.RankingChangeEvent;
import babase.ranker.ranking.RankingChangedListener;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.PrintStream;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.UIManager;

public class SwappableHeader
extends JPanel
implements RankingChangedListener,
ItemListener {
    private static final long serialVersionUID = -1447120517992527046L;
    protected Ranking _ranks;
    protected final Header[] _headers;
    protected SwappableHeaderCell[] _headerCells;
    protected int _lastPositionSelected = -1;
    protected PrintStream _out = System.out;

    public SwappableHeader(Ranking ranking, Header[] headerArray) {
        this._ranks = ranking;
        this._headers = headerArray;
        this._headerCells = new SwappableHeaderCell[this._ranks.size()];
        this._ranks.addChangedListener(this);
        this.setLayout(new GridLayout(this._ranks.size(), 1));
        int n = 0;
        while (n < this._ranks.size()) {
            this._headerCells[n] = new SwappableHeaderCell(n);
            this._headerCells[n].addItemListener(this);
            this.add(this._headerCells[n]);
            ++n;
        }
        this.refresh();
    }

    public int getDisplayWidth() {
        return Utils.findDisplayLength(this._headers);
    }

    public int getDisplayHeight() {
        return this._ranks.size();
    }

    public void setOut(PrintStream printStream) {
        this._out.flush();
        this._out = printStream;
    }

    protected void refreshHeaderButton(int n) {
        this._headerCells[n].setHeader(this._headers[this._ranks.get(n)]);
    }

    public void refresh() {
        int n = 0;
        while (n < this._ranks.size()) {
            this.refreshHeaderButton(n);
            ++n;
        }
    }

    public void rankingChanged(RankingChangeEvent rankingChangeEvent) {
        block3: {
            block4: {
                block2: {
                    if (!(rankingChangeEvent instanceof RankingChangeEvent.Slide)) break block2;
                    RankingChangeEvent.Slide slide = (RankingChangeEvent.Slide)rankingChangeEvent;
                    int n = slide.from > slide.to ? slide.to : slide.from;
                    int n2 = slide.from > slide.to ? slide.from : slide.to;
                    int n3 = n;
                    while (n3 <= n2) {
                        this.refreshHeaderButton(n3);
                        ++n3;
                    }
                    break block3;
                }
                if (!(rankingChangeEvent instanceof RankingChangeEvent.Swap)) break block4;
                RankingChangeEvent.Swap swap = (RankingChangeEvent.Swap)rankingChangeEvent;
                this.refreshHeaderButton(swap.i);
                this.refreshHeaderButton(swap.j);
                break block3;
            }
            if (!(rankingChangeEvent instanceof RankingChangeEvent.Permute)) break block3;
            int n = 0;
            while (n < this._ranks.size()) {
                this.refreshHeaderButton(n);
                ++n;
            }
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        int n = ((SwappableHeaderCell)itemEvent.getSource()).position;
        if (itemEvent.getStateChange() == 1) {
            if (this._lastPositionSelected == -1) {
                this._lastPositionSelected = n;
                this._out.println("Click on another header to SWAP with");
            } else {
                this._out.println("SWAP(" + this._lastPositionSelected + ", " + n + ")");
                this._headerCells[this._lastPositionSelected].removeItemListener(this);
                this._headerCells[this._lastPositionSelected].doClick();
                this._headerCells[this._lastPositionSelected].addItemListener(this);
                this._headerCells[n].removeItemListener(this);
                this._headerCells[n].doClick();
                this._headerCells[n].addItemListener(this);
                this._ranks.swap(this._lastPositionSelected, n, this);
                this._lastPositionSelected = -1;
            }
        } else if (itemEvent.getStateChange() == 2) {
            assert (n == this._lastPositionSelected);
            this._lastPositionSelected = -1;
        } else assert (false);
    }

    protected static class SwappableHeaderCell
    extends JToggleButton {
        private static final long serialVersionUID = 4834543388688688848L;
        protected static final Insets insets = new Insets(0, 0, 0, 0);
        protected final int position;

        public SwappableHeaderCell(int n) {
            this.position = n;
            this.setFont((Font)UIManager.get(String.valueOf(this.getClass().getName()) + ".font"));
            this.setMargin(insets);
            this.setHorizontalAlignment(0);
        }

        public void updateUI() {
            super.updateUI();
            this.setFont((Font)UIManager.get(String.valueOf(this.getClass().getName()) + ".font"));
        }

        public void setHeader(Header header) {
            this.setText(header.getText());
            this.setToolTipText(header.getToolTipText());
        }
    }
}

