package babase.ranker;

import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.PrintStream;

import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.UIManager;

import babase.ranker.ranking.Ranking;
import babase.ranker.ranking.RankingChangeEvent;
import babase.ranker.ranking.RankingChangedListener;

public class SwappableHeader extends JPanel implements RankingChangedListener,
        ItemListener {

    /**
     * Compiler-generated <code>serialVersionUID</code>.
     */
    private static final long serialVersionUID = -1447120517992527046L;

    protected static class SwappableHeaderCell extends JToggleButton {
        /**
         * Compiler-generated <code>serialVersionUID</code>.
         */
        private static final long serialVersionUID = 4834543388688688848L;

        protected static final Insets insets = new Insets(0, 0, 0, 0);

        protected final int position;

        public SwappableHeaderCell(int position) {
            super();
            this.position = position;
            setFont((Font) UIManager.get(getClass().getName() + ".font"));
            setMargin(insets);
            setHorizontalAlignment(JToggleButton.CENTER);
            return;
        }

        public void updateUI() {
            super.updateUI();
            setFont((Font) UIManager.get(getClass().getName() + ".font"));
            return;
        }

        public void setHeader(Header header) {
            setText(header.getText());
            setToolTipText(header.getToolTipText());
            return;
        }
    };

    protected Ranking _ranks;

    protected final Header[] _headers;

    protected SwappableHeaderCell[] _headerCells;

    protected int _lastPositionSelected = -1;

    protected PrintStream _out = System.out;

    public SwappableHeader(Ranking ranks, Header[] headers) {
        super();
        _ranks = ranks;
        _headers = headers;
        _headerCells = new SwappableHeaderCell[_ranks.size()];

        _ranks.addChangedListener(this);
        setLayout(new GridLayout(_ranks.size(), 1));
        for (int i = 0; i < _ranks.size(); i++) {
            _headerCells[i] = new SwappableHeaderCell(i);
            _headerCells[i].addItemListener(this);
            add(_headerCells[i]);
        }
        refresh();
        return;
    }

    public int getDisplayWidth() {
        return Utils.findDisplayLength(_headers);
    }

    public int getDisplayHeight() {
        return _ranks.size();
    }

    public void setOut(PrintStream out) {
        _out.flush();
        _out = out;
        return;
    }

    protected void refreshHeaderButton(int i) {
        _headerCells[i].setHeader(_headers[_ranks.get(i)]);
        return;
    }

    public void refresh() {
        for (int i = 0; i < _ranks.size(); i++) {
            refreshHeaderButton(i);
        }
        return;
    }

    public void rankingChanged(RankingChangeEvent e) {
        if (e instanceof RankingChangeEvent.Slide) {
            RankingChangeEvent.Slide slideEvent = (RankingChangeEvent.Slide) e;
            int lower = (slideEvent.from > slideEvent.to) ? slideEvent.to
                    : slideEvent.from;
            int upper = (slideEvent.from > slideEvent.to) ? slideEvent.from
                    : slideEvent.to;
            for (int i = lower; i <= upper; i++) {
                refreshHeaderButton(i);
            }
        } else if (e instanceof RankingChangeEvent.Swap) {
            RankingChangeEvent.Swap swapEvent = (RankingChangeEvent.Swap) e;
            refreshHeaderButton(swapEvent.i);
            refreshHeaderButton(swapEvent.j);
        } else if (e instanceof RankingChangeEvent.Permute) {
            for (int i = 0; i < _ranks.size(); i++) {
                refreshHeaderButton(i);
            }
        }
        return;
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.awt.event.ItemListener#itemStateChanged(java.awt.event.ItemEvent)
     */
    public void itemStateChanged(ItemEvent e) {
        int iChanged = ((SwappableHeaderCell) e.getSource()).position;
        if (e.getStateChange() == ItemEvent.SELECTED) {
            if (_lastPositionSelected == -1) {
                _lastPositionSelected = iChanged;
                _out.println("Click on another header to SWAP with");
            } else {
                _out.println("SWAP(" + _lastPositionSelected + ", " + iChanged
                        + ")");
                _headerCells[_lastPositionSelected].removeItemListener(this);
                _headerCells[_lastPositionSelected].doClick();
                _headerCells[_lastPositionSelected].addItemListener(this);
                _headerCells[iChanged].removeItemListener(this);
                _headerCells[iChanged].doClick();
                _headerCells[iChanged].addItemListener(this);
                _ranks.swap(_lastPositionSelected, iChanged, this);
                _lastPositionSelected = -1;
            }
        } else if (e.getStateChange() == ItemEvent.DESELECTED) {
            assert iChanged == _lastPositionSelected;
            _lastPositionSelected = -1;
        } else {
            assert false;
        }
        return;
    }

}
