package babase.ranker;

import babase.db.Babase;
import babase.db.Individual;

public class IndividualHeader extends Individual implements Header {

    public IndividualHeader(Individual individual) {
        super(individual);
    }

    /**
     * Retuns the text needed for tooltips.
     */
    public String getToolTipText() {
        StringBuffer buf = new StringBuffer();
        buf.append("<html>");
        buf.append("<b>" + sname + "</b> (" + name + ")");
        buf.append("<br>bioId: " + bioId);
        if (pid != null)
            buf.append("<br>pid: " + pid);
        buf.append("<br>birth: " + Babase.dateToString(birth));
        if (bStatus != null)
            buf.append("<br>bStatus: " + bStatus);
        if (sex != null)
            buf.append("<br>sex: " + sex);
        if (matGrp != null)
            buf.append("<br>matGrp: " + matGrp);
        if (statDate != null)
            buf.append("<br>statDate: " + Babase.dateToString(statDate));
        if (status != null)
            buf.append("<br>status: " + status);
        if (dCause != null)
            buf.append("<br>dCause: " + dCause);
        if (dCauseNatureConfidence != null)
            buf.append("<br>dCauseNatureConfidence: " + dCauseNatureConfidence);
        if (dCauseAgentConfidence != null)
            buf.append("<br>dCauseAgentConfidence: " + dCauseAgentConfidence);
        if (entrydate != null)
            buf.append("<br>Entrydate: " + Babase.dateToString(entrydate));
        if (entrytype != null)
            buf.append("<br>Entrytype: " + entrytype);
        if (matured != null)
            buf.append("<br>matured: " + Babase.dateToString(matured));
        if (ranked != null)
            buf.append("<br>ranked: " + Babase.dateToString(ranked));
        buf.append("</html>");
        return buf.toString();
    }

    /**
     * Returns the short name, or sname, of an individual.
     */
    public String getText() {
        return sname;
    }

}
