package babase.ranker;

import java.awt.Font;
import java.awt.GridLayout;
import java.io.OutputStream;
import java.io.PrintStream;

import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class MessagePanel extends JPanel {

    public static class GUIOutputStream extends OutputStream {

        protected static final String replacementString = "<truncated>";

        protected JTextArea _jTextArea;

        protected final int _maxChars;

        protected final int _targetChars;

        public GUIOutputStream(JTextArea jTextArea, int maxChars,
                int targetChars) {
            _jTextArea = jTextArea;
            _maxChars = maxChars;
            _targetChars = targetChars;
            assert _maxChars > _targetChars;
            return;
        }

        protected void append(String s) {
            _jTextArea.append(s);
            if (_jTextArea.getText().length() > _maxChars) {
                final String text = _jTextArea.getText();
                int i;
                for (i = text.length() - _targetChars; i < text.length(); i++) {
                    if (text.charAt(i) == '\n')
                        break;
                }
                if (i == text.length()) {
                    _jTextArea.setText("");
                } else {
                    _jTextArea.replaceRange(null, 0, i);
                }
            }
            _jTextArea.moveCaretPosition(_jTextArea.getText().length());
            return;
        }

        public void write(int b) {
            append(String.valueOf((char) b));
            return;
        }

        public void write(byte[] buf) {
            write(buf, 0, buf.length);
            return;
        }

        public void write(byte[] buf, int off, int len) {
            append(new String(buf, off, len));
            return;
        }
    }

    /**
     * Compiler-generated <code>serialVersionUID</code>.
     */
    private static final long serialVersionUID = -7025554328049046588L;

    protected static final Font font = new Font("Fixed", Font.PLAIN, 10);

    protected JTextArea _jTextArea;

    protected PrintStream _printStream;

    public MessagePanel(int maxChars) {
        super();
        // Use 1x1 GridLayout to force the component to be added to take up the
        // whole space in the this panel:
        setLayout(new GridLayout(1, 1));
        _jTextArea = new JTextArea(3, 70);
        _printStream = new PrintStream(new GUIOutputStream(_jTextArea,
                maxChars, maxChars));
        JScrollPane jScrollPane = new JScrollPane(_jTextArea,
                JScrollPane.VERTICAL_SCROLLBAR_ALWAYS,
                JScrollPane.HORIZONTAL_SCROLLBAR_ALWAYS);
        _jTextArea.setFont(font);
        _jTextArea.setEditable(false);
        add(jScrollPane);
        return;
    }

    public PrintStream getPrintStream() {
        return _printStream;
    }
}
