package babase.ranker;

import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.SwingConstants;

import babase.db.Babase;

import java.awt.BorderLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.sql.SQLException;

public class LoginUI extends JFrame {

    private static final long serialVersionUID = 1L;

    private final Babase _db;

    private ActionListener _connectedActionListener = null;
    
    private ActionListener _abortedActionListener = null;
    
    private final LoginUI _this = this;

    public LoginUI(Babase db) {
        _db = db;

        setTitle("Babase Login");
        setDefaultCloseOperation(JFrame.HIDE_ON_CLOSE);

        GridBagConstraints c = new GridBagConstraints();

        JPanel topPanel = new JPanel();
        topPanel.setLayout(new GridBagLayout());
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(10, 10, 10, 10);
        JLabel greeting = new JLabel("Database Login", SwingConstants.CENTER);
        topPanel.add(greeting, c);

        JPanel centerPanel = new JPanel();
        centerPanel.setLayout(new GridBagLayout());
        c.insets = new Insets(0, 0, 0, 0);
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = GridBagConstraints.LINE_END;
        centerPanel.add(new JLabel("Host: ", SwingConstants.RIGHT), c);
        c.gridx = 1;
        c.anchor = GridBagConstraints.LINE_START;
        final JTextField hostInput = new JTextField(
                "localhost", 15);
        centerPanel.add(hostInput, c);
        c.gridx = 0;
        c.gridy++;
        c.anchor = GridBagConstraints.LINE_END;
        centerPanel.add(new JLabel("Port: ", SwingConstants.RIGHT), c);
        c.gridx = 1;
        c.anchor = GridBagConstraints.LINE_START;
        final JTextField portInput = new JTextField("5432", 5);
        centerPanel.add(portInput, c);
        c.gridx = 1;
        c.gridy++;
        c.anchor = GridBagConstraints.LINE_START;
        final JCheckBox sslInput = new JCheckBox("Use SSL?");
        centerPanel.add(sslInput, c);
        sslInput.setSelected(false);
        c.gridx = 0;
        c.gridy++;
        c.anchor = GridBagConstraints.LINE_END;
        centerPanel.add(new JLabel("User Name: ", SwingConstants.RIGHT), c);
        c.gridx = 1;
        c.anchor = GridBagConstraints.LINE_START;
        final JTextField usernameInput = new JTextField(15);
        centerPanel.add(usernameInput, c);
        c.gridx = 0;
        c.gridy++;
        c.anchor = GridBagConstraints.LINE_END;
        centerPanel.add(new JLabel("Password: ", SwingConstants.RIGHT), c);
        c.gridx = 1;
        c.anchor = GridBagConstraints.LINE_START;
        final JPasswordField passwordInput = new JPasswordField(15);
        centerPanel.add(passwordInput, c);
        c.gridx = 0;
        c.gridy++;
        c.anchor = GridBagConstraints.LINE_END;
        centerPanel.add(new JLabel("Database: ", SwingConstants.RIGHT), c);
        c.gridx = 1;
        c.anchor = GridBagConstraints.LINE_START;
        String[] databases = { "babase", "babase_copy", "babase_test" };
        final JComboBox databaseInput = new JComboBox(databases);
        centerPanel.add(databaseInput, c);

        JPanel bottomPanel = new JPanel();
        bottomPanel.setLayout(new GridBagLayout());
        c.insets = new Insets(10, 10, 10, 10);
        c.gridx = 1;
        c.gridy = 0;
        c.gridx = 1;
        c.gridy = 2;
        c.gridwidth = 2;
        JButton connect = new JButton("Connect");
        connect.setMnemonic(KeyEvent.VK_C);
        connect.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                String host = hostInput.getText();
                String port = portInput.getText();
                Boolean ssl = sslInput.isSelected();
                String username = usernameInput.getText();
                String password = new String(passwordInput.getPassword());
                String database = (String) databaseInput.getSelectedItem();
                try {
                    _db.connect(host, port, username, password, database, ssl);
                    setVisible(false);
                    _connectedActionListener.actionPerformed(e);
                } catch (SQLException sqlException) {
                    Utils.showErrorDialog(_this, sqlException.getMessage());
                }
                return;
            }
        });
        getRootPane().setDefaultButton(connect);
        bottomPanel.add(connect, c);
        c.gridx = 0;
        c.gridy = 2;
        c.gridwidth = 1;
        JButton abort = new JButton("Abort");
        abort.setMnemonic(KeyEvent.VK_A);
        abort.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                setVisible(false);
                _abortedActionListener.actionPerformed(e);
                return;
            }
        });
        bottomPanel.add(abort, c);

        getContentPane().setLayout(new BorderLayout());
        getContentPane().add(topPanel, BorderLayout.PAGE_START);
        getContentPane().add(centerPanel, BorderLayout.CENTER);
        getContentPane().add(bottomPanel, BorderLayout.PAGE_END);

        setResizable(false);
        pack();
        setLocationRelativeTo(null);
        return;
    }

    public void start(ActionListener connectedActionListener, ActionListener abortedActionListener) {
        _connectedActionListener = connectedActionListener;
        _abortedActionListener = abortedActionListener;
        setVisible(true);
        return;
    }

}
